/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.jira.bulkedit.operation.BulkEditAction;
import com.atlassian.jira.bulkedit.operation.BulkOperationException;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.issue.bulkedit.WorkflowTransitionKey;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowProgressAware;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BulkWorkflowTransitionOperation
implements ProgressAwareBulkOperation {
    protected static final Logger log = Logger.getLogger(BulkWorkflowTransitionOperation.class);
    public static final String NAME = "BulkWorkflowTransition";
    public static final String NAME_KEY = "bulk.workflowtransition.operation.name";
    private static final String DESCRIPTION_KEY = "bulk.workflowtransition.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.workflowtransition.cannotperform";
    private final WorkflowManager workflowManager;
    private final IssueWorkflowManager issueWorkflowManager;
    private final FieldLayoutManager fieldLayoutManager;

    public BulkWorkflowTransitionOperation(WorkflowManager workflowManager, IssueWorkflowManager issueWorkflowManager, FieldLayoutManager fieldLayoutManager) {
        this.workflowManager = workflowManager;
        this.issueWorkflowManager = issueWorkflowManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, ApplicationUser remoteUser) {
        return this.canPerformOnAnyIssue(bulkEditBean, remoteUser);
    }

    public boolean canPerformOnAnyIssue(BulkEditBean bulkEditBean, ApplicationUser remoteUser) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        for (Issue issue : selectedIssues) {
            Collection availableActions = this.issueWorkflowManager.getAvailableActions(issue, remoteUser);
            if (availableActions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void perform(BulkEditBean bulkEditBean, ApplicationUser applicationUser, Context taskContext) throws BulkOperationException {
        ActionDescriptor actionDescriptor = this.getActionDescriptor(bulkEditBean.getSelectedWFTransitionKey());
        for (Issue issue1 : bulkEditBean.getSelectedIssues()) {
            Context.Task task = taskContext.start((Object)issue1);
            MutableIssue issue = (MutableIssue)issue1;
            Collection availableActions = this.issueWorkflowManager.getAvailableActions((Issue)issue, applicationUser);
            if (!availableActions.contains(actionDescriptor)) {
                task.complete();
                continue;
            }
            HashMap additionalInputs = Maps.newHashMap();
            Map selectedActions = bulkEditBean.getActions();
            if (selectedActions != null) {
                for (BulkEditAction bulkEditAction : bulkEditBean.getActions().values()) {
                    OrderableField field = bulkEditAction.getField();
                    FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeId()).getFieldLayoutItem(field);
                    if (fieldLayoutItem == null) continue;
                    if ("comment".equals(field.getId())) {
                        ((CommentSystemField)field).populateAdditionalInputs(bulkEditBean.getFieldValuesHolder(), additionalInputs);
                        continue;
                    }
                    field.updateIssue(fieldLayoutItem, issue, bulkEditBean.getFieldValuesHolder());
                }
            }
            BulkWorkflowProgressAware bulkWorkflowProgressAware = new BulkWorkflowProgressAware(applicationUser, actionDescriptor.getId(), issue, issue.getProjectObject());
            additionalInputs.put("sendBulkNotification", bulkEditBean.isSendBulkNotification());
            bulkWorkflowProgressAware.setAdditionalInputs(additionalInputs);
            this.workflowManager.doWorkflowAction((WorkflowProgressAware)bulkWorkflowProgressAware);
            if (bulkWorkflowProgressAware.hasError()) {
                bulkEditBean.addTransitionErrors(issue.getKey(), bulkWorkflowProgressAware.getErrors());
            }
            task.complete();
        }
    }

    public int getNumberOfTasks(BulkEditBean bulkEditBean) {
        return bulkEditBean.getSelectedIssues().size();
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public String getOperationName() {
        return NAME;
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }

    public ActionDescriptor getActionDescriptor(WorkflowTransitionKey workflowTransitionKey) {
        String workflowName = workflowTransitionKey.getWorkflowName();
        String actionDescriptorId = workflowTransitionKey.getActionDescriptorId();
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        return workflow.getDescriptor().getAction(Integer.parseInt(actionDescriptorId));
    }

    static class BulkWorkflowProgressAware
    implements WorkflowProgressAware {
        private ApplicationUser remoteUser;
        private int actionId;
        private MutableIssue issue;
        private Project project;
        private Map additionalInputs;
        private Collection<String> errors = new ArrayList<String>();

        public BulkWorkflowProgressAware(ApplicationUser remoteUser, int actionId, MutableIssue issue, Project project) {
            this.remoteUser = remoteUser;
            this.actionId = actionId;
            this.issue = issue;
            this.project = project;
        }

        public ApplicationUser getRemoteUser() {
            return this.remoteUser;
        }

        public ApplicationUser getRemoteApplicationUser() {
            return this.remoteUser;
        }

        public int getAction() {
            return this.actionId;
        }

        public void setAction(int action) {
            this.actionId = action;
        }

        public void addErrorMessage(String error) {
            this.errors.add(error);
        }

        public void addError(String name, String error) {
            this.errors.add(error);
        }

        public boolean hasError() {
            return !this.errors.isEmpty();
        }

        public Map getAdditionalInputs() {
            return this.additionalInputs;
        }

        public void setAdditionalInputs(Map additionalInputs) {
            this.additionalInputs = additionalInputs;
        }

        public MutableIssue getIssue() {
            return this.issue;
        }

        public Project getProject() {
            return this.project;
        }

        public Project getProjectObject() {
            return this.project;
        }

        public Collection<String> getErrors() {
            return this.errors;
        }
    }
}

