/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperationException;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkMigrateOperation
implements ProgressAwareBulkOperation {
    public static final String OPERATION_NAME = "BulkMigrate";
    public static final String NAME_KEY = "bulk.move.operation.name";
    private static final String DESCRIPTION_KEY = "bulk.move.operation.description";
    private static final Logger log = LoggerFactory.getLogger(BulkMigrateOperation.class);
    private final BulkMoveOperation bulkMoveOperation;

    public BulkMigrateOperation(BulkMoveOperation bulkMoveOperation) {
        this.bulkMoveOperation = bulkMoveOperation;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, ApplicationUser remoteUser) {
        return this.bulkMoveOperation.canPerform(bulkEditBean, remoteUser);
    }

    public void perform(BulkEditBean rootBulkEditBean, ApplicationUser applicationUser, Context taskContext) throws BulkOperationException {
        try {
            MultiBulkMoveBean multiBulkMoveBean = rootBulkEditBean.getRelatedMultiBulkMoveBean();
            for (Object value : multiBulkMoveBean.getBulkEditBeans().values()) {
                BulkEditBean bulkEditBean = (BulkEditBean)value;
                log.debug("Performing move for project " + bulkEditBean.getTargetProject().getName() + " issue type: " + bulkEditBean.getTargetIssueType().getName());
                this.bulkMoveOperation.moveIssuesAndIndex(bulkEditBean, applicationUser, taskContext);
                MultiBulkMoveBean relatedMultiBulkMoveBean = bulkEditBean.getRelatedMultiBulkMoveBean();
                if (relatedMultiBulkMoveBean == null || relatedMultiBulkMoveBean.getBulkEditBeans() == null) continue;
                for (Object o : relatedMultiBulkMoveBean.getBulkEditBeans().values()) {
                    BulkEditBean subTaskBulkEditBean = (BulkEditBean)o;
                    log.info("subTaskBulkEditBean move for project " + subTaskBulkEditBean.getTargetProject().getName() + " issue type: " + subTaskBulkEditBean.getTargetIssueType().getName());
                    this.bulkMoveOperation.moveIssuesAndIndex(subTaskBulkEditBean, applicationUser, taskContext);
                }
            }
        }
        catch (Exception e) {
            throw new BulkOperationException((Throwable)e);
        }
    }

    public int getNumberOfTasks(BulkEditBean rootBulkEditBean) {
        int count = 0;
        for (Object o1 : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o1;
            count += bulkEditBean.getSelectedIssues().size();
            MultiBulkMoveBean relatedMultiBulkMoveBean = bulkEditBean.getRelatedMultiBulkMoveBean();
            if (relatedMultiBulkMoveBean == null || relatedMultiBulkMoveBean.getBulkEditBeans() == null) continue;
            for (Object o : relatedMultiBulkMoveBean.getBulkEditBeans().values()) {
                BulkEditBean subTaskBulkEditBean = (BulkEditBean)o;
                count += subTaskBulkEditBean.getSelectedIssues().size();
            }
        }
        return count;
    }

    public void chooseContext(BulkEditBean rootBulkEditBean, ApplicationUser applicationUser, I18nHelper i18nHelper, ErrorCollection errors) {
        for (Object o : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o;
            this.bulkMoveOperation.chooseContext(bulkEditBean, applicationUser, i18nHelper, errors);
        }
    }

    public void chooseContextNoValidate(BulkEditBean rootBulkEditBean, ApplicationUser applicationUser) {
        this.bulkMoveOperation.chooseContextNoValidate(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean(), applicationUser);
    }

    public boolean isStatusValid(BulkEditBean rootBulkEditBean) {
        return this.bulkMoveOperation.isStatusValid(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean());
    }

    public void setStatusFields(BulkEditBean rootBulkEditBean) throws WorkflowException {
        this.bulkMoveOperation.setStatusFields(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean());
    }

    public void validatePopulateFields(BulkEditBean rootBulkEditBean, I18nHelper i18nHelper, ErrorCollection errors) {
        this.bulkMoveOperation.validatePopulateFields(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean(), errors, i18nHelper);
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public String getOperationName() {
        return OPERATION_NAME;
    }

    public String getCannotPerformMessageKey() {
        return "bulk.move.cannotperform";
    }

    public BulkMoveOperation getBulkMoveOperation() {
        return this.bulkMoveOperation;
    }
}

