/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class UserValidationHelper {
    private final I18nHelper.BeanFactory i18nFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final UserManager userManager;
    private final PasswordPolicyManager passwordPolicyManager;

    public UserValidationHelper(I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, UserManager userManager, PasswordPolicyManager passwordPolicyManager) {
        this.i18nFactory = i18nFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.passwordPolicyManager = passwordPolicyManager;
    }

    public Validations validations(@Nullable ApplicationUser applicationUser) {
        return new Validations(Optional.ofNullable(applicationUser));
    }

    class Validations {
        private final int MAX_FIELD_LENGTH = 255;
        private final char[] INVALID_USERNAME_CHARS = new char[]{'<', '>', '&'};
        private final ErrorCollection errors = new SimpleErrorCollection();
        private final I18nHelper i18nBean;

        public Validations(Optional<ApplicationUser> applicationUser) {
            this.i18nBean = applicationUser.isPresent() ? UserValidationHelper.this.i18nFactory.getInstance(applicationUser.get()) : UserValidationHelper.this.jiraAuthenticationContext.getI18nHelper();
        }

        public ErrorCollection getErrors() {
            return this.errors;
        }

        private void addErrorMessage(String i18nKey) {
            this.errors.addErrorMessage(this.i18nBean.getText(i18nKey));
        }

        private void addErrorMessage(String i18nKey, Object param) {
            this.errors.addErrorMessage(this.i18nBean.getText(i18nKey, param));
        }

        private void addError(String fieldName, String i18nKey) {
            this.errors.addError(fieldName, this.i18nBean.getText(i18nKey));
        }

        public boolean hasWritableDirectory() {
            if (!UserValidationHelper.this.userManager.hasWritableDirectory()) {
                this.addErrorMessage("admin.errors.cannot.add.user.all.directories.read.only");
                return false;
            }
            return true;
        }

        public boolean writableDirectory(Long directoryId) {
            Directory directory = UserValidationHelper.this.userManager.getDirectory(directoryId);
            if (directory == null) {
                this.addErrorMessage("admin.errors.cannot.add.user.no.such.directory", directoryId);
                return false;
            }
            if (!directory.getAllowedOperations().contains(OperationType.CREATE_USER)) {
                this.addErrorMessage("admin.errors.cannot.add.user.read.only.directory", directory.getName());
                return false;
            }
            return true;
        }

        public boolean hasCreateAccess(@Nonnull ApplicationUser userPerformingCreate) {
            if (!UserValidationHelper.this.permissionManager.hasPermission(0, userPerformingCreate)) {
                this.addErrorMessage("admin.errors.user.no.permission.to.create");
                return false;
            }
            return true;
        }

        public boolean passwordRequired(String password) {
            if (StringUtils.isEmpty((CharSequence)password)) {
                this.errors.addError(UserService.FieldName.PASSWORD, this.i18nBean.getText("signup.error.password.required"));
                return false;
            }
            return true;
        }

        public boolean validateConfirmPassword(String password, String confirmPassword) {
            if (!(!StringUtils.isNotEmpty((CharSequence)confirmPassword) && !StringUtils.isNotEmpty((CharSequence)password) || password != null && password.equals(confirmPassword))) {
                this.addError(UserService.FieldName.CONFIRM_PASSWORD, "signup.error.password.mustmatch");
                return false;
            }
            return true;
        }

        public List<WebErrorMessage> validatePasswordPolicy(String password, String username, String displayName, String email) {
            Collection<WebErrorMessage> webErrorMessages = UserValidationHelper.this.passwordPolicyManager.checkPolicy(username, displayName, email, password);
            if (!webErrorMessages.isEmpty()) {
                this.addError(UserService.FieldName.PASSWORD, "signup.error.password.rejected");
            }
            return ImmutableList.copyOf(webErrorMessages);
        }

        public boolean validateEmailAddress(String emailAddress) {
            if (StringUtils.isEmpty((CharSequence)emailAddress)) {
                this.addError(UserService.FieldName.EMAIL, "signup.error.email.required");
                return false;
            }
            if (emailAddress.length() > 255) {
                this.addError(UserService.FieldName.EMAIL, "signup.error.email.greater.than.max.chars");
                return false;
            }
            if (!TextUtils.verifyEmail((String)emailAddress)) {
                this.addError(UserService.FieldName.EMAIL, "signup.error.email.valid");
                return false;
            }
            return true;
        }

        public boolean validateDisplayName(String displayName) {
            if (StringUtils.isEmpty((CharSequence)displayName)) {
                this.addError(UserService.FieldName.FULLNAME, "signup.error.fullname.required");
                return false;
            }
            if (displayName.length() > 255) {
                this.addError(UserService.FieldName.FULLNAME, "signup.error.full.name.greater.than.max.chars");
                return false;
            }
            return true;
        }

        public boolean hasValidUsername(String username, Long directoryId) {
            if (this.hasRequiredUsername(username) && this.validateUsernamePolicy(username)) {
                return this.usernameDoesNotExist(directoryId, username);
            }
            return false;
        }

        public boolean hasRequiredUsername(String username) {
            if (StringUtils.isEmpty((CharSequence)username)) {
                this.addError(UserService.FieldName.NAME, "signup.error.username.required");
                return false;
            }
            return true;
        }

        public boolean validateUsernamePolicy(String username) {
            if (username.length() > 255) {
                this.addError(UserService.FieldName.NAME, "signup.error.username.greater.than.max.chars");
                return false;
            }
            if (StringUtils.containsAny((CharSequence)username, (char[])this.INVALID_USERNAME_CHARS)) {
                this.addError(UserService.FieldName.NAME, "signup.error.username.invalid.chars");
                return false;
            }
            return true;
        }

        public boolean usernameDoesNotExist(Long directoryId, @Nonnull String username) {
            if (directoryId != null) {
                if (UserValidationHelper.this.userManager.findUserInDirectory(username, directoryId) != null) {
                    this.addError(UserService.FieldName.NAME, "signup.error.username.exists");
                    return false;
                }
                return true;
            }
            if (UserValidationHelper.this.userManager.getUserByName(username) != null) {
                this.addError(UserService.FieldName.NAME, "signup.error.username.exists");
                return false;
            }
            return true;
        }
    }
}

