/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.group;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.fugue.ImmutableMaps;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsersToApplicationsSeatingHelper {
    private static final Logger log = LoggerFactory.getLogger(UsersToApplicationsSeatingHelper.class);
    private final ApplicationRoleManager applicationRoleManager;
    private final DirectoryManager directoryManager;

    public UsersToApplicationsSeatingHelper(ApplicationRoleManager applicationRoleManager, DirectoryManager directoryManager) {
        this.applicationRoleManager = applicationRoleManager;
        this.directoryManager = directoryManager;
    }

    public Map<ApplicationRole, Set<ApplicationUser>> rolesToBeAddedForSeatingCountPurpose(Set<ApplicationUser> users, Set<String> groupsToBeAdded) {
        HashMultimap userToRoles = HashMultimap.create();
        for (ApplicationUser user : users) {
            userToRoles.putAll((Object)user, this.calculateRolesToBeAdded(user, groupsToBeAdded));
        }
        return ImmutableMaps.transformValue((Map)((HashMultimap)Multimaps.invertFrom((Multimap)userToRoles, (Multimap)HashMultimap.create())).asMap(), ImmutableSet::copyOf);
    }

    public Set<ApplicationRole> findEffectiveApplications(long directoryId, Set<ApplicationRole> roles) {
        Set defaultGroupsNames = (Set)roles.stream().map(ApplicationRole::getDefaultGroups).flatMap(Collection::stream).map(Group::getName).collect(CollectorsUtil.toImmutableSet());
        return this.findEffectiveApplicationsByGroups(directoryId, defaultGroupsNames);
    }

    public Set<ApplicationRole> findEffectiveApplicationsByGroups(long userDirectoryId, Set<String> groupsNames) {
        return (Set)this.applicationRoleManager.getRoles().stream().filter(role -> role.getGroups().stream().map(Group::getName).anyMatch(roleGivingGroup -> groupsNames.stream().anyMatch(this.isEqualOrNestedGroup(userDirectoryId, (String)roleGivingGroup)))).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<ApplicationRole> calculateRolesToBeAdded(ApplicationUser user, Set<String> groupsToBeAdded) {
        if (log.isTraceEnabled()) {
            log.trace("Calculating application access for {} with groups {}", (Object)user, groupsToBeAdded);
        }
        Set existingUserRoles = this.applicationRoleManager.getRolesForUser(user);
        Set<ApplicationRole> rolesToBeAdded = this.findEffectiveApplicationsByGroups(user.getDirectoryId(), groupsToBeAdded);
        Set rolesToBeAddedToThisUser = Sets.difference(rolesToBeAdded, (Set)existingUserRoles).copyInto(new HashSet());
        Sets.SetView effectiveRolesAfterAdd = Sets.union((Set)existingUserRoles, rolesToBeAdded);
        if (effectiveRolesAfterAdd.stream().anyMatch(r -> !r.getKey().equals((Object)ApplicationKeys.CORE))) {
            rolesToBeAddedToThisUser.remove(this.applicationRoleManager.getRole(ApplicationKeys.CORE).getOrNull());
        }
        return rolesToBeAddedToThisUser;
    }

    private Predicate<String> isEqualOrNestedGroup(long userDirectoryId, String roleGivingGroup) {
        Predicate<String> nameEqualsIgnoreCase = val -> IdentifierUtils.equalsInLowerCase((String)roleGivingGroup, (String)val);
        return nameEqualsIgnoreCase.or(this.isGivenGroupNestedGroup(userDirectoryId, roleGivingGroup));
    }

    private Predicate<String> isGivenGroupNestedGroup(long directory, String parentGroup) {
        return childGroup -> {
            try {
                return this.directoryManager.isGroupNestedGroupMember(directory, childGroup, parentGroup);
            }
            catch (DirectoryNotFoundException e) {
                log.warn("Could not find directory with id {}", (Object)directory);
                return false;
            }
            catch (OperationFailedException e) {
                log.warn("Group inheritance check failed", (Throwable)e);
                return false;
            }
        };
    }
}

