/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.config.util.JiraHome;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.io.FilenameUtils;

public class AvatarTaggerImpl
implements AvatarTagger {
    public static final String FORMAT_NAME = "javax_imageio_png_1.0";
    private static final String AVATAR_DIRECTORY = "data/avatars";
    private static final String TAGGED_AVATAR_FILE_SUFFIX = "jrvtg.png";
    private final JiraHome jiraHome;

    public AvatarTaggerImpl(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
    }

    public File getAvatarBaseDirectory() {
        return new File(this.jiraHome.getHome(), AVATAR_DIRECTORY);
    }

    @Override
    public String tagAvatar(long id, String filename) throws IOException {
        String sizeFlag;
        File base = this.getAvatarBaseDirectory();
        for (AvatarManager.ImageSize size : AvatarManager.ImageSize.values()) {
            sizeFlag = size.getFilenameFlag();
            File avatarFileInstance = new File(base, id + "_" + sizeFlag + filename);
            if (!avatarFileInstance.exists()) continue;
            AvatarTaggerImpl.tagAvatarFile(avatarFileInstance, AvatarTaggerImpl.toTaggedName(avatarFileInstance.getAbsolutePath()));
        }
        try {
            for (AvatarManager.ImageSize size : AvatarManager.ImageSize.values()) {
                sizeFlag = size.getFilenameFlag();
                File oldAvatarFile = new File(base, id + "_" + sizeFlag + filename);
                if (!oldAvatarFile.exists()) continue;
                oldAvatarFile.delete();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return AvatarTaggerImpl.toTaggedName(filename);
    }

    private static String toTaggedName(String filename) {
        return FilenameUtils.removeExtension((String)filename) + TAGGED_AVATAR_FILE_SUFFIX;
    }

    static void tagAvatarFile(File file) throws IOException {
        AvatarTaggerImpl.tagAvatarFile(file, file.getAbsolutePath());
    }

    private static void tagAvatarFile(File file, String newName) throws IOException {
        File outFile = new File(newName);
        BufferedImage in = ImageIO.read(file);
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        IIOMetadata metadata = AvatarTaggerImpl.metadata(writer, writeParam);
        writer.setOutput(new FileImageOutputStream(outFile));
        writer.write(metadata, new IIOImage(in, null, metadata), writeParam);
    }

    @Override
    public void saveTaggedAvatar(RenderedImage in, String format, OutputStream targetStream) throws IOException {
        ImageWriter writer;
        try {
            writer = ImageIO.getImageWritersByFormatName(format).next();
        }
        catch (NoSuchElementException x) {
            throw new IllegalArgumentException("format: '" + format + "'");
        }
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        IIOMetadata metadata = AvatarTaggerImpl.metadata(writer, writeParam);
        MemoryCacheImageOutputStream imageOutputStream = new MemoryCacheImageOutputStream(targetStream);
        writer.setOutput(imageOutputStream);
        writer.write(metadata, new IIOImage(in, null, metadata), writeParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTaggedAvatar(RenderedImage in, String name, File file) throws IOException {
        try (FileImageOutputStream stream = new FileImageOutputStream(file);){
            ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            IIOMetadata metadata = AvatarTaggerImpl.metadata(writer, writeParam);
            writer.setOutput(stream);
            writer.write(metadata, new IIOImage(in, null, metadata), writeParam);
        }
    }

    private static IIOMetadata metadata(ImageWriter writer, ImageWriteParam writeParam) throws IIOInvalidTreeException {
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        IIOMetadataNode root = new IIOMetadataNode(FORMAT_NAME);
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        IIOMetadataNode textEntry = new IIOMetadataNode("tEXtEntry");
        textEntry.setAttribute("keyword", "jira-system-image-type");
        textEntry.setAttribute("value", "avatar");
        textEntry.setAttribute("encoding", "UTF-8");
        textEntry.setAttribute("language", "EN");
        textEntry.setAttribute("compression", "none");
        text.appendChild(textEntry);
        root.appendChild(text);
        metadata.mergeTree(FORMAT_NAME, root);
        return metadata;
    }
}

