/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AssociatedItemImpl;
import com.atlassian.jira.auditing.AuditRecord;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class AuditRecordImpl
implements AuditRecord {
    public static final String ID = "id";
    public static final String AUTHOR_KEY = "authorKey";
    public static final String REMOTE_ADDR = "remoteAddress";
    public static final String CATEGORY = "category";
    public static final String CREATED = "created";
    public static final String SUMMARY = "summary";
    public static final String OBJECT_TYPE = "objectType";
    public static final String OBJECT_NAME = "objectName";
    public static final String OBJECT_PARENT_ID = "objectParentId";
    public static final String OBJECT_PARENT_NAME = "objectParentName";
    public static final String OBJECT_ID = "objectId";
    public static final String AUTHOR_TYPE = "authorType";
    public static final String EVENT_SOURCE = "eventSourceName";
    public static final String DESCRIPTION = "description";
    public static final String SEARCH_FIELD = "searchField";
    protected final GenericValue gv;
    protected final ImmutableList<AssociatedItem> associatedItems;
    protected final ImmutableList<ChangedValue> changedValues;

    public AuditRecordImpl(GenericValue gv, Iterable<AssociatedItem> associatedItems, Iterable<ChangedValue> changedValues) {
        this.gv = gv;
        this.associatedItems = ImmutableList.copyOf(associatedItems);
        this.changedValues = ImmutableList.copyOf(changedValues);
    }

    @Nonnull
    public Long getId() {
        return this.gv.getLong(ID);
    }

    @Nullable
    public String getAuthorKey() {
        return this.gv.getString(AUTHOR_KEY);
    }

    @Nullable
    public String getRemoteAddr() {
        return this.gv.getString(REMOTE_ADDR);
    }

    @Nonnull
    public Date getCreated() {
        return this.gv.getTimestamp(CREATED);
    }

    @Nonnull
    public AuditingCategory getCategory() {
        return AuditingCategory.getCategoryById((String)this.gv.getString(CATEGORY));
    }

    @Nonnull
    public String getSummary() {
        return this.gv.getString(SUMMARY);
    }

    @Nonnull
    public String getEventSource() {
        return this.gv.getString(EVENT_SOURCE);
    }

    @Nullable
    public String getDescription() {
        return this.gv.getString(DESCRIPTION);
    }

    @Nonnull
    public Iterable<AssociatedItem> getAssociatedItems() {
        return this.associatedItems;
    }

    @Nonnull
    public Iterable<ChangedValue> getValues() {
        return this.changedValues;
    }

    @Nullable
    public AssociatedItem getObjectItem() {
        if (this.gv.getString(OBJECT_NAME) != null && this.gv.getString(OBJECT_TYPE) != null) {
            return new AssociatedItemImpl(this.gv);
        }
        return null;
    }
}

