/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.util;

import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class OFBizPropertyUtils {
    private static final ClassLoader MY_CLASS_LOADER = OFBizPropertyUtils.class.getClassLoader();

    public static PropertySet getPropertySet(String entityName, Long entityId) {
        return OFBizPropertyUtils.getPropertySet("ofbiz", null, entityName, entityId);
    }

    public static PropertySet getPropertySet(GenericValue gv) {
        return OFBizPropertyUtils.getPropertySet("ofbiz", gv.delegatorName, gv.getEntityName(), gv.getLong("id"));
    }

    public static PropertySet getCachingPropertySet(String entityName, Long entityId) {
        return OFBizPropertyUtils.getPropertySet("ofbiz-cached", null, entityName, entityId);
    }

    public static PropertySet getCachingPropertySet(GenericValue gv) {
        return OFBizPropertyUtils.getPropertySet("ofbiz-cached", gv.delegatorName, gv.getEntityName(), gv.getLong("id"));
    }

    private static PropertySet getPropertySet(@Nonnull String propertySetType, @Nullable String delegatorName, @Nonnull String entityName, @Nonnull Long entityId) {
        FieldMap ofbizArgs = FieldMap.build((String)"delegator.name", (Object)delegatorName, (String)"entityName", (Object)Assertions.notNull((String)"entityName", (Object)entityName), (String)"entityId", (Object)Assertions.notNull((String)"entityId", (Object)entityId));
        return PropertySetManager.getInstance((String)propertySetType, (Map)ofbizArgs, (ClassLoader)OFBizPropertyUtils.getClassLoader());
    }

    private static ClassLoader getClassLoader() {
        return MY_CLASS_LOADER;
    }

    public static void removePropertySet(String entityName, Long entityId) {
        OFBizPropertyUtils.getCachingPropertySet(entityName, entityId).remove();
    }

    public static void removePropertySet(GenericValue gv) {
        OFBizPropertyUtils.getCachingPropertySet(gv).remove();
    }
}

