/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.velocity.CachingJiraClassMap;
import com.atlassian.velocity.JiraClassMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.util.introspection.ClassMap;
import org.apache.velocity.util.introspection.IntrospectorCache;

public class JiraIntrospectorCache
implements IntrospectorCache {
    private final Cache<Class<?>, ClassMap> classMapCache;

    public JiraIntrospectorCache(Log log) {
        CacheManager cacheManager = (CacheManager)ComponentAccessor.getComponentOfType(CacheManager.class);
        this.classMapCache = cacheManager.getCache(JiraIntrospectorCache.class.getName() + ".cache", new CacheLoader<Class<?>, ClassMap>(){

            @Nonnull
            public ClassMap load(@Nonnull Class<?> key) {
                return new CachingJiraClassMap(new JiraClassMap(key));
            }
        }, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void clear() {
        this.classMapCache.removeAll();
    }

    public ClassMap get(Class clazz) {
        return (ClassMap)this.classMapCache.get((Object)clazz);
    }

    public ClassMap put(Class clazz) {
        return (ClassMap)this.classMapCache.get((Object)clazz);
    }
}

