/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.configuration;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.exception.DataAccessException;
import com.google.common.base.Supplier;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.config.DefaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFactory
implements Supplier<Configuration> {
    private Logger log = LoggerFactory.getLogger(ConfigurationFactory.class);

    public Configuration get() {
        try {
            DefaultConfiguration configuration = new DefaultConfiguration();
            configuration.load(ClassLoaderUtils.getResource((String)"osworkflow.xml", this.getClass()));
            try {
                configuration.getWorkflowStore();
                return configuration;
            }
            catch (StoreException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
        catch (FactoryException e) {
            this.log.error("Error loading OSWorkflow Configuration: " + (Object)((Object)e), (Throwable)e);
            throw new InfrastructureException("Error loading osworkflow.xml file: " + (Object)((Object)e), e);
        }
    }
}

