/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.WorkflowSchemeStore;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

abstract class WorkflowSchemeStateBuilderTemplate<B extends WorkflowSchemeStore.State.Builder<B>>
implements WorkflowSchemeStore.State.Builder<B> {
    private Long id;
    private Map<String, String> schemeMap;

    WorkflowSchemeStateBuilderTemplate() {
        this.id = null;
        this.schemeMap = Maps.newHashMap();
    }

    WorkflowSchemeStateBuilderTemplate(WorkflowSchemeStore.State state) {
        this.id = state.getId();
        this.schemeMap = Maps.newHashMap(state.getMappings());
    }

    @Override
    public String getDefaultWorkflow() {
        return this.schemeMap.get(null);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getDefault() {
        return this.schemeMap.get(null);
    }

    @Override
    public Map<String, String> getMappings() {
        return this.schemeMap;
    }

    @Override
    public B setMappings(Map<String, String> mappings) {
        Assertions.notNull((String)"mappings", mappings);
        HashMap schemeMap = Maps.newHashMap();
        for (Map.Entry<String, String> entries : mappings.entrySet()) {
            String value;
            String key = entries.getKey();
            if (key != null) {
                if (StringUtils.isBlank((String)key)) {
                    throw new IllegalArgumentException("issueTypeId cannot be blank.");
                }
                if (key.length() > 255) {
                    throw new IllegalArgumentException("issueTypeId '" + key + "' is too long.");
                }
            }
            if (StringUtils.isBlank((String)(value = entries.getValue()))) {
                throw new IllegalArgumentException(String.format("workflowName in mappings[%s] cannot be blank.", key));
            }
            if (value.length() > 255) {
                throw new IllegalArgumentException(String.format("workflowName in mappings[%s] = %s too long.", key, value));
            }
            schemeMap.put(key, value);
        }
        this.schemeMap = schemeMap;
        return this.getThis();
    }

    abstract B getThis();
}

