/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.sitemesh;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.decorator.DecoratorMapperModuleDescriptor;
import com.atlassian.jira.plugin.decorator.DecoratorModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDecoratorMapper
extends AbstractDecoratorMapper {
    private static final Logger log = LoggerFactory.getLogger(PluginDecoratorMapper.class);

    public Decorator getDecorator(HttpServletRequest httpServletRequest, Page page) {
        PluginAccessor pluginAccessor = this.getPluginAccessor();
        if (pluginAccessor != null) {
            Decorator decorator = this.getDecoratorFromPluginMappers(httpServletRequest, page, pluginAccessor);
            if (decorator != null) {
                return decorator;
            }
            decorator = this.getDecoratorFromPluginDecorators(httpServletRequest, pluginAccessor);
            if (decorator != null) {
                return decorator;
            }
        }
        return super.getDecorator(httpServletRequest, page);
    }

    private Decorator getDecoratorFromPluginDecorators(HttpServletRequest httpServletRequest, PluginAccessor pluginAccessor) {
        List decoratorModuleDescriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(DecoratorModuleDescriptor.class);
        for (DecoratorModuleDescriptor desc : decoratorModuleDescriptors) {
            Matcher matcher;
            if (log.isDebugEnabled()) {
                log.debug("Trying decorator " + desc.getPluginKey() + ":" + desc.getKey() + " on servlet path " + httpServletRequest.getServletPath());
            }
            if (desc.getPattern() == null || !(matcher = desc.getPattern().matcher(httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()))).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Matched decorator plugin with key " + desc.getPluginKey() + ":" + desc.getKey() + " on path " + httpServletRequest.getServletPath() + " using expression " + desc.getPattern() + ".  Decorating with page " + desc.getPage());
            }
            return this.createDefaultDecorator(desc);
        }
        return null;
    }

    private Decorator getDecoratorFromPluginMappers(HttpServletRequest httpServletRequest, Page page, PluginAccessor pluginAccessor) {
        List decoratorMapperModuleDescriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(DecoratorMapperModuleDescriptor.class);
        for (DecoratorMapperModuleDescriptor desc : decoratorMapperModuleDescriptors) {
            DecoratorMapper decoratorMapper;
            if (log.isDebugEnabled()) {
                log.debug("Trying mapper " + desc.getPluginKey() + ":" + desc.getKey() + " on servlet path " + httpServletRequest.getServletPath());
            }
            if ((decoratorMapper = desc.getDecoratorMapper(this.config, this.parent)) != null) {
                Decorator decorator = decoratorMapper.getDecorator(httpServletRequest, page);
                if (decorator == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Matched decorator mapper plugin with key " + desc.getPluginKey() + ":" + desc.getKey() + " on path " + httpServletRequest.getServletPath() + ". Returning decorator named " + decorator.getName());
                }
                return decorator;
            }
            log.warn("Decorator mapper null: " + desc.getPluginKey() + ":" + desc.getKey());
        }
        return null;
    }

    public Decorator getNamedDecorator(HttpServletRequest httpServletRequest, String name) {
        PluginAccessor pluginAccessor = this.getPluginAccessor();
        if (pluginAccessor != null) {
            List decoratorMapperModuleDescriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(DecoratorMapperModuleDescriptor.class);
            for (DecoratorMapperModuleDescriptor desc : decoratorMapperModuleDescriptors) {
                DecoratorMapper decoratorMapper = desc.getDecoratorMapper(this.config, this.parent);
                if (decoratorMapper != null) {
                    Decorator decorator = decoratorMapper.getNamedDecorator(httpServletRequest, name);
                    if (decorator == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Decorator mapper " + desc.getPluginKey() + ":" + desc.getKey() + " returned decorator for name " + name);
                    }
                    return decorator;
                }
                log.warn("Decorator mapper null: " + desc.getPluginKey() + ":" + desc.getKey());
            }
            List decoratorModuleDescriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(DecoratorModuleDescriptor.class);
            for (DecoratorModuleDescriptor desc : decoratorModuleDescriptors) {
                if (!name.equals(desc.getName())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Decorator " + desc.getPluginKey() + ":" + desc.getKey() + " matched name " + name);
                }
                return this.createDefaultDecorator(desc);
            }
        }
        return super.getNamedDecorator(httpServletRequest, name);
    }

    private Decorator createDefaultDecorator(DecoratorModuleDescriptor desc) {
        return new DefaultDecorator(desc.getName(), desc.getPage(), null);
    }

    PluginAccessor getPluginAccessor() {
        if (ComponentManager.getInstance() != null) {
            return ComponentAccessor.getPluginAccessor();
        }
        return null;
    }
}

