/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.requestcleanup;

import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterStep;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;
import webwork.action.factory.SessionMap;
import webwork.dispatcher.GenericDispatcher;
import webwork.util.ServletValueStack;

public class WebworkActionCleanupStep
implements FilterStep {
    private static final Logger log = LoggerFactory.getLogger(WebworkActionCleanupStep.class);

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext callContext) {
        this.blatActionContextWithRedMatter();
        callContext.getHttpServletRequest().setAttribute("jira.webwork.cleanup", (Object)Boolean.FALSE);
        return callContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext callContext) {
        HttpServletRequest httpServletRequest = callContext.getHttpServletRequest();
        boolean cleanedUp = false;
        try {
            GenericDispatcher gd = (GenericDispatcher)httpServletRequest.getAttribute("jira.webwork.generic.dispatcher");
            if (gd != null) {
                cleanedUp = true;
                httpServletRequest.setAttribute("webwork.valuestack.head", ServletValueStack.getStack((ServletRequest)httpServletRequest).popValue());
                gd.finalizeContext();
            }
        }
        finally {
            this.detectDirtyActionContext(httpServletRequest, cleanedUp);
        }
        return callContext;
    }

    private void detectDirtyActionContext(HttpServletRequest httpServletRequest, boolean attemptedCleanup) {
        Map contextTable;
        ActionContext currentContext = ActionContext.getContext();
        if (currentContext != null && (contextTable = currentContext.getTable()) != null && !contextTable.isEmpty()) {
            Object requestObj;
            String url = this.getRequestString(httpServletRequest);
            Object sessionMap = contextTable.get("webwork.action.ActionContext.action");
            if (sessionMap != null && SessionMap.class.equals(sessionMap.getClass())) {
                log.error("Thread corrupted! ActionContext still references a HttpSession. URL: '" + url + "' ");
            }
            if ((requestObj = contextTable.get("webwork.action.ServletContext.request")) != null) {
                log.error("Thread corrupted! ActionContext still references a HttpRequest. URL: '" + url + "'. Attempted to clean up: " + attemptedCleanup);
            }
            if (log.isDebugEnabled()) {
                StringBuilder nonNullKeys = new StringBuilder();
                for (Object key : contextTable.keySet()) {
                    nonNullKeys.append(key).append(", ");
                }
                log.debug("Thread corrupted! ActionContext has the following : " + nonNullKeys + " URL: '" + url + "' ");
            }
            this.blatActionContextWithRedMatter();
        }
    }

    private String getRequestString(HttpServletRequest httpServletRequest) {
        String queryString = httpServletRequest.getQueryString();
        return httpServletRequest.getRequestURL() + (queryString == null ? "" : "?" + queryString);
    }

    private void blatActionContextWithRedMatter() {
        ActionContextKit.resetContext();
    }
}

