/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.license.SIDManager;
import org.apache.commons.lang.StringUtils;

public class SetupAccount
extends AbstractSetupAction {
    private static final String SETUP_INSTANT = "instant";
    private String setupOption = "classic";
    private final SIDManager sidManager;

    public SetupAccount(FileFactory fileFactory, JiraProperties jiraProperties, SIDManager sidManager) {
        super(fileFactory, jiraProperties);
        this.sidManager = sidManager;
    }

    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        return "input";
    }

    public String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.setupOption.equals(SETUP_INSTANT)) {
            return this.forceRedirect("SetupFinishing!default.jspa");
        }
        return this.forceRedirect("SetupDatabase!default.jspa");
    }

    public String getSetupOption() {
        return this.setupOption;
    }

    public void setSetupOption(String setupOption) {
        this.setupOption = setupOption;
    }

    @Override
    public String getServerId() {
        String serverId = this.getApplicationProperties().getString("jira.sid.key");
        if (StringUtils.isBlank((String)serverId)) {
            serverId = this.sidManager.generateSID();
            this.getApplicationProperties().setString("jira.sid.key", serverId);
        }
        return serverId;
    }

    @ActionViewData
    public String getErrorTextsJson() throws JSONException {
        I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(this.getLocale());
        JSONObject json = new JSONObject();
        json.put("invalidEmail", (Object)i18nHelper.getText("setup.account.form.email.invalid"));
        json.put("emailRequired", (Object)i18nHelper.getText("setup.account.form.email.required"));
        json.put("invalidCredentials", (Object)i18nHelper.getText("setup.account.invalid.credentials"));
        json.put("passwordRequired", (Object)i18nHelper.getText("setup.account.form.password.required"));
        json.put("agreementRequired", (Object)i18nHelper.getText("setup.account.form.agreement.required"));
        json.put("fullnameRequired", (Object)i18nHelper.getText("setup.account.form.fullname.required"));
        return json.toString();
    }
}

