/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.subtasks;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeTemplateProperties;
import com.atlassian.jira.web.action.issue.URLUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Map;

@WebSudoRequired
public class EditSubTaskIssueTypes
extends JiraWebActionSupport
implements IssueTypeTemplateProperties {
    private final SubTaskManager subTaskManager;
    private final ConstantsManager constantsManager;
    private String id;
    private String name;
    private Long sequence;
    private String description;
    private String iconurl;
    private Long avatarId;

    public EditSubTaskIssueTypes(SubTaskManager subTaskManager, ConstantsManager constantsManager) {
        this.subTaskManager = subTaskManager;
        this.constantsManager = constantsManager;
    }

    public String doDefault() throws Exception {
        if (!this.isSubtasksEnabled()) {
            this.addErrorMessage(this.getText("admin.errors.subtasks.disabled"));
            return this.getResult();
        }
        if (!TextUtils.stringSet((String)this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.no.id.set"));
            return this.getResult();
        }
        IssueType subTaskIssueType = this.subTaskManager.getSubTaskIssueType(this.getId());
        this.setName(subTaskIssueType.getName());
        this.setSequence(subTaskIssueType.getSequence());
        this.setDescription(subTaskIssueType.getDescription());
        this.setIconurl(subTaskIssueType.getIconUrl());
        if (null != subTaskIssueType.getAvatar()) {
            this.setAvatarId(subTaskIssueType.getAvatar().getId());
        }
        return "input";
    }

    protected void doValidation() {
        if (!this.isSubtasksEnabled()) {
            this.addErrorMessage(this.getText("admin.errors.subtasks.are.disabled"));
            return;
        }
        if (!TextUtils.stringSet((String)this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.no.id.set"));
        } else if (!TextUtils.stringSet((String)this.getName())) {
            this.addError("name", this.getText("admin.errors.specify.a.name.for.this.new.sub.task.issue.type"));
        } else {
            IssueConstant subTaskIssueType = this.constantsManager.getIssueConstantByName("IssueType", this.getName());
            if (subTaskIssueType != null && !this.getId().equals(subTaskIssueType.getId())) {
                this.addError("name", this.getText("admin.errors.issue.type.with.this.name.already.exists"));
            }
        }
        if (this.avatarId == null && !TextUtils.stringSet((String)this.getIconurl())) {
            this.addError("iconurl", this.getText("admin.errors.issuetypes.must.specify.url"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.subTaskManager.updateSubTaskIssueType(this.getId(), this.getName(), this.getSequence(), this.getDescription(), this.getAvatarId());
        return this.getRedirect("ManageSubTasks.jspa");
    }

    private boolean isSubtasksEnabled() {
        return this.subTaskManager.isSubTasksEnabled();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconurl() {
        return this.iconurl;
    }

    public void setIconurl(String iconurl) {
        this.iconurl = iconurl;
    }

    @Override
    public Long getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(Long avatarId) {
        this.avatarId = avatarId;
    }

    @Override
    @ActionViewData(key="issueType")
    public IssueTypeViewData getIssueTypeValue() {
        return new IssueTypeViewData();
    }

    @Override
    @ActionViewData
    public String getAction() {
        return "EditSubTaskIssueTypes.jspa";
    }

    @Override
    @ActionViewData
    public String getCancelAction() {
        return "ManageSubTasks.jspa";
    }

    @Override
    @ActionViewData
    public String getActiveTab() {
        return "subtasks";
    }

    @Override
    @ActionViewData
    public String getToken() {
        return super.getXsrfToken();
    }

    @Override
    @ActionViewData(key="errors")
    public Map<String, Object> getWrappedErrorsForView() {
        return MapBuilder.newBuilder().add((Object)"errors", (Object)super.getErrors()).toMap();
    }

    @Override
    @ActionViewData
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @Override
    @ActionViewData
    public String getDefaultAvatarId() {
        return this.getApplicationProperties().getString("jira.avatar.issuetype.subtask.default.id");
    }

    @Override
    @ActionViewData
    public String getEditTitleTextId() {
        return this.getI18nHelper().getText("admin.subtasks.edit.subtask.issue.type");
    }

    private class IssueTypeViewData
    implements IssueTypeTemplateProperties.IssueTypeViewData {
        private IssueTypeViewData() {
        }

        @Override
        public String getName() {
            return EditSubTaskIssueTypes.this.getName();
        }

        @Override
        public String getDescription() {
            return EditSubTaskIssueTypes.this.getName();
        }

        @Override
        public String getId() {
            return EditSubTaskIssueTypes.this.getId();
        }

        @Override
        public Long getAvatarId() {
            return EditSubTaskIssueTypes.this.getAvatarId();
        }

        @Override
        public String getIconUrlContent() {
            String iconurl = EditSubTaskIssueTypes.this.getIconurl();
            String contextPath = EditSubTaskIssueTypes.this.getHttpRequest().getContextPath();
            return URLUtil.addContextPathToURLIfAbsent(contextPath, iconurl);
        }
    }
}

