/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.statuses;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.admin.constants.AbstractEditConstant;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@WebSudoRequired
public class EditStatus
extends AbstractEditConstant<Status> {
    private Long statusCategory;
    private final StatusService statusService;
    private final ConstantsService constantsService;
    private static final String PLACEHOLDER_VALUE = "-1";
    private static final String CATEGORY_HELP_UTIL_KEY = "statuses";

    public EditStatus(StatusService statusService, ConstantsService constantsService) {
        this.statusService = statusService;
        this.constantsService = constantsService;
    }

    @Override
    protected String getConstantEntityName() {
        return "Status";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.status.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "status";
    }

    @Override
    protected Status getConstant(String id) {
        return this.getConstantsManager().getStatusObject(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewStatuses.jspa";
    }

    @Override
    protected Collection<Status> getConstants() {
        return this.getConstantsManager().getStatusObjects();
    }

    @Override
    public String getIconurl() {
        if (null == this.iconurl || this.iconurl.isEmpty()) {
            this.iconurl = this.getStatus().getIconUrl();
        }
        return this.iconurl;
    }

    @Override
    protected void doValidation() {
        ServiceResult validation = this.statusService.validateEditStatus(this.getLoggedInUser(), this.getStatus(), this.name, this.description, this.getIconurl(), this.getStatusCategoryObject());
        if (validation.isValid()) {
            super.doValidation();
        } else {
            this.addErrorCollection(validation.getErrorCollection());
        }
        if (this.statusCategory != null && PLACEHOLDER_VALUE.equals(String.valueOf(this.statusCategory))) {
            this.addError("statusCategory", this.getText("admin.errors.must.specify.status.category"));
        }
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshStatuses();
    }

    public Collection<StatusCategory> getStatusCategories() {
        return (Collection)this.constantsService.getAllStatusCategories(this.getLoggedInUser()).getReturnedValue();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ServiceOutcome outcome = this.statusService.editStatus(this.getLoggedInUser(), this.getStatus(), this.name, this.description, this.getIconurl(), this.getStatusCategoryObject());
        this.addErrorCollection(outcome.getErrorCollection());
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.returnCompleteWithInlineRedirect(this.getRedirectPage());
    }

    private StatusCategory getStatusCategoryObject() {
        StatusCategory category = this.getStatusLozengeEnabled() ? (StatusCategory)this.constantsService.getStatusCategoryById(this.getLoggedInUser(), String.valueOf(this.statusCategory)).getReturnedValue() : null;
        return category;
    }

    private Status getStatus() {
        return this.statusService.getStatusById(this.getLoggedInUser(), this.id);
    }

    @ActionViewData(key="status")
    public SimpleStatus getStatusFormValues() {
        return new SimpleStatusImpl(this.getId(), this.getName(), this.getDescription(), this.getStatusCategoryObject(), this.getIconurl());
    }

    @ActionViewData(key="isIconUrlFieldVisible")
    public boolean isIconUrlFieldVisible() {
        return !this.getStatusLozengeEnabled();
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> outputErrorsForSoy() {
        return MapBuilder.newBuilder().add((Object)"errors", (Object)super.getErrors()).toMap();
    }

    @ActionViewData
    public String getToken() {
        return super.getXsrfToken();
    }

    @ActionViewData
    public HelpUtil.HelpPath getStatusCategoryHelpData() {
        return HelpUtil.getInstance().getHelpPath(CATEGORY_HELP_UTIL_KEY);
    }

    public Long getStatusCategory() {
        Status s;
        if (this.statusCategory == null && (s = this.getStatus()) != null && s.getStatusCategory() != null) {
            this.statusCategory = this.getStatus().getStatusCategory().getId();
        }
        return this.statusCategory;
    }

    @ActionViewData
    public List<Map<String, Object>> getStatusCategoryOptions() {
        ArrayList options = Collections.emptyList();
        if (this.getStatusLozengeEnabled()) {
            StatusCategory undefinedCategory = (StatusCategory)this.constantsService.getDefaultStatusCategory(this.getLoggedInUser()).getReturnedValue();
            boolean isCurrentUndefined = this.getStatus().getStatusCategory() != null ? this.getStatus().getStatusCategory().equals(undefinedCategory) : true;
            Collection sc = (Collection)this.constantsService.getUserVisibleStatusCategories(this.getLoggedInUser()).getReturnedValue();
            options = Lists.newArrayList((Iterable)Iterables.transform((Iterable)sc, (Function)new Function<StatusCategory, Map<String, Object>>(){

                public Map<String, Object> apply(@Nullable StatusCategory input) {
                    MapBuilder builder = MapBuilder.newBuilder();
                    if (null != input) {
                        builder.add((Object)"text", (Object)input.getTranslatedName(EditStatus.this.getI18nHelper()));
                        builder.add((Object)"value", (Object)input.getId());
                        builder.add((Object)"key", (Object)input.getKey());
                        builder.add((Object)"colorName", (Object)input.getColorName());
                        builder.add((Object)"sequence", (Object)input.getSequence());
                        builder.add((Object)"selected", (Object)(null != input.getId() && input.getId().equals(EditStatus.this.getStatusCategory()) ? 1 : 0));
                    }
                    return builder.toMap();
                }
            }));
            if (isCurrentUndefined && (this.statusCategory == null || undefinedCategory.getId().equals(this.statusCategory) || PLACEHOLDER_VALUE.equals(String.valueOf(this.statusCategory)))) {
                MapBuilder builder = MapBuilder.newBuilder();
                builder.add((Object)"text", (Object)this.getText("admin.issuesettings.statuses.status.category.please.select"));
                builder.add((Object)"value", (Object)PLACEHOLDER_VALUE);
                builder.add((Object)"key", (Object)"");
                builder.add((Object)"colorName", (Object)"");
                builder.add((Object)"sequence", (Object)"");
                builder.add((Object)"selected", (Object)true);
                builder.add((Object)"isPlaceholder", (Object)true);
                options.add(builder.toMap());
            }
        }
        return options;
    }

    public void setStatusCategory(Long statusCategory) {
        this.statusCategory = statusCategory;
    }

    public boolean getStatusLozengeEnabled() {
        return this.constantsService.isStatusAsLozengeEnabled();
    }
}

