/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;

@WebSudoRequired
public class ConfigureFieldScreen
extends JiraWebActionSupport {
    private final FieldScreenManager fieldScreenManager;
    private final ProjectFieldScreenHelper helper;
    private final JiraWebResourceManager webResourceManager;
    private Long id;
    private FieldScreen fieldScreen;
    private List<Project> projects;

    public ConfigureFieldScreen(FieldScreenManager fieldScreenManager, ProjectFieldScreenHelper helper, JiraWebResourceManager webResourceManager) {
        this.fieldScreenManager = fieldScreenManager;
        this.helper = helper;
        this.webResourceManager = webResourceManager;
    }

    public String doDefault() throws Exception {
        return this.doExecute();
    }

    protected String doExecute() throws Exception {
        this.webResourceManager.requireResource("com.atlassian.jira.jira-project-config-plugin:screens-editor");
        if (this.id == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
        } else {
            this.fieldScreen = this.fieldScreenManager.getFieldScreen(this.id);
            if (this.fieldScreen == null) {
                this.addErrorMessage(this.getText("admin.issuefields.screens.configure.no.screen", String.valueOf(this.id)));
            }
        }
        return this.getResult();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FieldScreen getFieldScreen() {
        return this.fieldScreen;
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            this.projects = this.helper.getProjectsForFieldScreen(this.getFieldScreen());
        }
        return this.projects;
    }
}

