/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.status.JobDetails;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class DeleteJobRunner
extends JiraWebActionSupport {
    private final SchedulerService schedulerService;
    private final String SCHEDULER_ADMIN_URL = "SchedulerAdmin.jspa";
    private boolean confirm;
    private String runnerKey;

    public DeleteJobRunner(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public String execute() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.runnerKey)) {
            return this.getRedirect("SchedulerAdmin.jspa");
        }
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)this.runnerKey);
        if (this.schedulerService.getRegisteredJobRunnerKeys().contains(jobRunnerKey)) {
            this.addErrorMessage(this.getText("admin.schedulerdetails.only.abandoned", this.runnerKey));
            return "error";
        }
        if (StringUtils.isNotEmpty((CharSequence)this.runnerKey) && this.confirm) {
            List jobs = this.schedulerService.getJobsByJobRunnerKey(jobRunnerKey);
            for (JobDetails job : jobs) {
                try {
                    this.schedulerService.unscheduleJob(job.getJobId());
                }
                catch (SchedulerRuntimeException sre) {
                    this.addErrorMessage(this.getText("admin.schedulerdetails.failed.to.remove", job.getJobId().toString(), sre.getMessage()));
                }
            }
            if (this.hasAnyErrors()) {
                return "error";
            }
            return this.returnCompleteWithInlineRedirect("SchedulerAdmin.jspa");
        }
        return "input";
    }

    @ActionViewData(value="error")
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @ActionViewData
    public String getRunnerKey() {
        return this.runnerKey;
    }

    public void setRunnerKey(String runnerKey) {
        this.runnerKey = runnerKey;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

