/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NotClusteredException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.upgrade.UpgradeLauncher;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraSystemRestarterImpl
implements JiraSystemRestarter {
    private static final Logger log = LoggerFactory.getLogger(JiraSystemRestarterImpl.class);
    private static final String JIRA_IS_ABOUT_TO_BE_INTERNALLY_RESTARTED = "JIRA is about to be internally restarted";
    private static final String JIRA_HAS_BEEN_INTERNALLY_RESTARTED = "JIRA has been internally restarted";

    @Override
    public void ariseSirJIRA() {
        log.info(JIRA_IS_ABOUT_TO_BE_INTERNALLY_RESTARTED);
        this.stopServicesInOtherThreads();
        this.restartPico();
        this.startServicesInOtherThreads();
        this.quiescePassiveNode();
        log.info(JIRA_HAS_BEEN_INTERNALLY_RESTARTED);
    }

    @Override
    public void ariseSirJIRAandUpgradeThySelf(ServletContext servletContext) {
        log.info(JIRA_IS_ABOUT_TO_BE_INTERNALLY_RESTARTED);
        this.stopServicesInOtherThreads();
        this.restartPico();
        UpgradeLauncher.checkIfUpgradeNeeded(servletContext, (JohnsonProvider)ComponentAccessor.getComponent(JohnsonProvider.class));
        this.startServicesInOtherThreads();
        this.quiescePassiveNode();
        log.info(JIRA_HAS_BEEN_INTERNALLY_RESTARTED);
    }

    private void restartPico() {
        log.info("Restarting JIRA code components...");
        ManagerFactory.globalRefresh();
        log.info("JIRA code components started");
    }

    private void stopServicesInOtherThreads() {
        log.info("Stopping the JIRA Scheduler...");
        JiraSystemRestarterImpl.getSchedulerService().shutdown();
        log.info("JIRA Scheduler Stopped");
        log.info("Emptying the JIRA Mail Queue...");
        try {
            ComponentAccessor.getMailQueue().sendBuffer();
            log.info("JIRA Mail Queue emptied");
        }
        catch (Exception e) {
            log.warn("Failed to empty the Mail Queue: " + e.getMessage(), (Throwable)e);
        }
    }

    private void startServicesInOtherThreads() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (clusterManager.isActive()) {
            log.info("Restarting the JIRA Scheduler...");
            try {
                JiraSystemRestarterImpl.getSchedulerService().start();
            }
            catch (SchedulerServiceException e) {
                throw new SchedulerRuntimeException("Unable to restart the JIRA scheduler", (Throwable)e);
            }
            log.info("JIRA Scheduler started");
        }
    }

    private void quiescePassiveNode() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (!clusterManager.isActive()) {
            NodeStateManager nodeStateManager = (NodeStateManager)ComponentAccessor.getComponent(NodeStateManager.class);
            try {
                nodeStateManager.deactivate();
            }
            catch (NotClusteredException notClusteredException) {
                // empty catch block
            }
        }
    }

    private static LifecycleAwareSchedulerService getSchedulerService() {
        return (LifecycleAwareSchedulerService)ComponentAccessor.getComponent(LifecycleAwareSchedulerService.class);
    }
}

