/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.BridgedDirectoryUser;
import com.atlassian.jira.util.dbc.Assertions;

public class DelegatingApplicationUser
implements ApplicationUser {
    private final String key;
    private final User user;
    private final User bridgedUser;

    public DelegatingApplicationUser(String key, User user) {
        this.key = (String)Assertions.notNull((String)"key", (Object)key);
        this.user = (User)Assertions.notNull((String)"user", (Object)user);
        this.bridgedUser = new BridgedDirectoryUser(user, this);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isActive() {
        return this.user.isActive();
    }

    public String getEmailAddress() {
        return this.user.getEmailAddress();
    }

    public String getDisplayName() {
        return this.user.getDisplayName();
    }

    public User getDirectoryUser() {
        return this.bridgedUser;
    }

    public String getUsername() {
        return this.user.getName();
    }

    public String getName() {
        return this.user.getName();
    }

    public long getDirectoryId() {
        return this.user.getDirectoryId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ApplicationUser) {
            ApplicationUser other = (ApplicationUser)obj;
            return this.key.equals(other.getKey());
        }
        if (obj instanceof User) {
            throw new IllegalArgumentException("You must update your code to use ApplicationUser (you passed User to equals here)");
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.getUsername() + '(' + this.getKey() + ')';
    }
}

