/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.UseBasedMigration;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Sets;
import java.util.Set;

final class UseBasedMigrationImpl
extends UseBasedMigration {
    private final GlobalPermissionDao dao;

    UseBasedMigrationImpl(GlobalPermissionDao dao) {
        this.dao = (GlobalPermissionDao)Assertions.notNull((String)"dao", (Object)dao);
    }

    @Override
    MigrationState addUsePermissionToRoles(MigrationState state, Iterable<ApplicationKey> keys) {
        Assertions.notNull((String)"state", (Object)state);
        Assertions.notNull((String)"keys", keys);
        Set<Group> adminGroups = this.dao.groupsWithAdminPermission();
        Set<Group> useGroups = this.dao.groupsWithUsePermission();
        Sets.SetView allGroups = Sets.union(adminGroups, useGroups);
        Sets.SetView defaultGroups = Sets.difference(useGroups, adminGroups);
        MigrationState migratedState = state;
        for (ApplicationKey key : keys) {
            migratedState = migratedState.changeApplicationRole(key, arg_0 -> UseBasedMigrationImpl.lambda$addUsePermissionToRoles$27((Set)allGroups, (Set)defaultGroups, arg_0));
        }
        return migratedState;
    }

    private static /* synthetic */ ApplicationRole lambda$addUsePermissionToRoles$27(Set set, Set set2, ApplicationRole role) {
        return role.addGroups(set).addGroupsAsDefault(set2);
    }
}

