/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationValidator;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationValidatorImpl
extends MigrationValidator {
    private static final Logger log = LoggerFactory.getLogger(MigrationValidatorImpl.class);
    private final GlobalPermissionDao globalPermissionDao;

    MigrationValidatorImpl(GlobalPermissionDao globalPermissionDao) {
        this.globalPermissionDao = (GlobalPermissionDao)Assertions.notNull((String)"globalPermissionDao", (Object)globalPermissionDao);
    }

    @Override
    void validate(MigrationState original, MigrationState resulting) {
        Assertions.notNull((String)"original", (Object)original);
        Assertions.notNull((String)"resulting", (Object)resulting);
        this.verifyAdministrators(original, resulting);
    }

    private void verifyAdministrators(MigrationState original, MigrationState resulting) {
        Set invariantDefaultGroups = (Set)original.applicationRoles().asMap().values().stream().flatMap(role -> role.defaultGroups().stream()).collect(CollectorsUtil.toImmutableSet());
        Set defaultGroups = (Set)resulting.applicationRoles().asMap().values().stream().flatMap(role -> role.defaultGroups().stream()).collect(CollectorsUtil.toImmutableSet());
        Sets.SetView newDefaultGroups = Sets.difference((Set)defaultGroups, (Set)invariantDefaultGroups);
        Sets.SetView defaultAdminGroups = Sets.intersection(this.globalPermissionDao.groupsWithAdminPermission(), (Set)newDefaultGroups);
        if (!defaultAdminGroups.isEmpty()) {
            Set groupNames = (Set)defaultAdminGroups.stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet());
            log.error("Administrator groups have become default: " + String.join((CharSequence)", ", groupNames));
            throw new MigrationFailedException("Administrator groups have become default group in application role:" + String.join((CharSequence)", ", groupNames));
        }
        Set applicationGroups = (Set)resulting.applicationRoles().asMap().values().stream().flatMap(role -> role.groups().stream()).collect(CollectorsUtil.toImmutableSet());
        Sets.SetView droppedAdminGroups = Sets.difference(this.globalPermissionDao.groupsWithAdminPermission(), (Set)applicationGroups);
        if (!droppedAdminGroups.isEmpty()) {
            log.warn("The following administrator groups were not migrated properly: " + String.join((CharSequence)", ", (Iterable)droppedAdminGroups.stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet())));
        }
    }
}

