/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.jira.license.JiraProductLicense;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import javax.annotation.Nonnull;

final class LicenseUtils {
    private LicenseUtils() {
    }

    public static ServiceDeskLicenseType determineServiceDeskLicenseType(@Nonnull License license) {
        JiraProductLicense productLicense = license.productLicense();
        if (Boolean.valueOf(productLicense.getProperty("com.atlassian.servicedesk.active")).booleanValue()) {
            String roleCountStr = productLicense.getProperty("com.atlassian.servicedesk.numRoleCount");
            if (roleCountStr == null) {
                return ServiceDeskLicenseType.TierBasedPricing;
            }
            return ServiceDeskLicenseType.AgentBasedPricing;
        }
        throw new MigrationFailedException("Not a service desk license: " + license.toString());
    }

    static enum ServiceDeskLicenseType {
        AgentBasedPricing,
        TierBasedPricing;

    }
}

