/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class GlobalPermissionDaoImpl
extends GlobalPermissionDao {
    private static final String AGENT_GLOBAL_PERMISSION_NAME = "com.atlassian.servicedesk.agent.access";
    private final OfBizDelegator db;
    private final Supplier<Set<Group>> useGroups;
    private final Supplier<Set<Group>> adminGroups;
    private final Supplier<Set<Group>> sdAgentGroups;

    GlobalPermissionDaoImpl(OfBizDelegator db) {
        this.db = (OfBizDelegator)Assertions.notNull((String)"db", (Object)db);
        this.useGroups = Suppliers.memoize(() -> this.getGlobalGroups("USE"));
        this.adminGroups = Suppliers.memoize(() -> Sets.union(this.getGlobalGroups("ADMINISTER"), this.getGlobalGroups("SYSTEM_ADMIN")));
        this.sdAgentGroups = Suppliers.memoize(() -> this.getGlobalGroups(AGENT_GLOBAL_PERMISSION_NAME));
    }

    @Override
    Set<Group> groupsWithUsePermission() {
        return (Set)this.useGroups.get();
    }

    @Override
    Set<Group> groupsWithAdminPermission() {
        return (Set)this.adminGroups.get();
    }

    @Override
    Set<Group> groupsWithSdAgentPermission() {
        return (Set)this.sdAgentGroups.get();
    }

    private ImmutableSet<Group> getGlobalGroups(String permission) {
        return (ImmutableSet)this.db.findByAnd("GlobalPermissionEntry", (Map)ImmutableMap.of((Object)"permission", (Object)permission)).stream().map(gv -> gv.getString("group_id")).filter(Objects::nonNull).map(ImmutableGroup::new).collect(CollectorsUtil.toImmutableSet());
    }
}

