/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.jira.CachingComponent;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRoles;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRolesDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationRolesDaoImpl
extends ApplicationRolesDao {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationRolesDaoImpl.class);
    private static final String APPLICATION_ROLE_ENTITY = "LicenseRoleGroup";
    private final OfBizDelegator db;
    private final ApplicationRoleManager applicationRoleManager;

    public ApplicationRolesDaoImpl(OfBizDelegator db, ApplicationRoleManager applicationRoleManager) {
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.db = (OfBizDelegator)Assertions.notNull((String)"db", (Object)db);
    }

    @Override
    ApplicationRoles get() {
        List group = this.db.findAll(APPLICATION_ROLE_ENTITY);
        HashMap roles = Maps.newHashMap();
        for (GenericValue genericValue : group) {
            String keyString = genericValue.getString("licenseRoleName");
            try {
                ApplicationKey key = ApplicationKey.valueOf((String)keyString);
                String groupName = genericValue.getString("groupId");
                if (groupName == null) continue;
                ApplicationRole newRole = roles.computeIfAbsent(key, ApplicationRole::forKey);
                newRole = Boolean.TRUE.equals(genericValue.getBoolean("primaryGroup")) ? newRole.addGroupAsDefault((Group)new ImmutableGroup(groupName)) : newRole.addGroup((Group)new ImmutableGroup(groupName));
                roles.put(key, newRole);
            }
            catch (IllegalArgumentException ignored) {
                LOG.debug("Invalid key '{}' in the database.", (Object)keyString);
            }
        }
        return new ApplicationRoles(roles.values());
    }

    @Override
    void put(ApplicationRoles applicationRoles) {
        try {
            Set<ApplicationKey> wantedRoles = applicationRoles.asMap().keySet();
            if (!wantedRoles.containsAll(this.getCurrentApplicationKeys())) {
                throw new MigrationFailedException("Trying to remove application roles.");
            }
            applicationRoles.asMap().values().forEach(this::put);
        }
        finally {
            if (this.applicationRoleManager instanceof CachingComponent) {
                ((CachingComponent)this.applicationRoleManager).clearCache();
            }
        }
    }

    private Set<ApplicationKey> getCurrentApplicationKeys() {
        return this.db.findAll(APPLICATION_ROLE_ENTITY).stream().map(gv -> gv.getString("licenseRoleName")).filter(ApplicationKey::isValid).map(ApplicationKey::valueOf).collect(Collectors.toSet());
    }

    private void put(ApplicationRole role) {
        HashSet currentGroups = Sets.newHashSet();
        for (GenericValue row : this.db.findByAnd(APPLICATION_ROLE_ENTITY, (Map)ImmutableMap.of((Object)"licenseRoleName", (Object)role.key().value()))) {
            String groupId = row.getString("groupId");
            if (groupId == null) {
                this.db.removeValue(row);
                continue;
            }
            ImmutableGroup group = new ImmutableGroup(groupId);
            boolean hasLowerCaseIdentifier = IdentifierUtils.toLowerCase((String)groupId).equals(groupId);
            if (hasLowerCaseIdentifier && role.groups().contains(group)) {
                currentGroups.add(group);
                Boolean currentDefault = row.getBoolean("primaryGroup");
                boolean wantedDefault = role.defaultGroups().contains(group);
                if (currentDefault != null && currentDefault.equals(wantedDefault)) continue;
                row.set("primaryGroup", (Object)wantedDefault);
                this.db.store(row);
                continue;
            }
            this.db.removeValue(row);
        }
        for (Group newGroup : Sets.difference(role.groups(), (Set)currentGroups)) {
            this.db.createValue(APPLICATION_ROLE_ENTITY, (Map)FieldMap.build((String)"licenseRoleName", (Object)role.key().value(), (String)"groupId", (Object)IdentifierUtils.toLowerCase((String)newGroup.getName()), (String)"primaryGroup", (Object)role.defaultGroups().contains(newGroup)));
        }
    }

    private static class Columns {
        private static final String NAME = "licenseRoleName";
        private static final String GROUP_ID = "groupId";
        private static final String DEFAULT = "primaryGroup";

        private Columns() {
        }
    }
}

