/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

final class ApplicationRole {
    private final ApplicationKey key;
    private final ImmutableSet<Group> groups;
    private final ImmutableSet<Group> defaultGroups;

    static ApplicationRole forKey(ApplicationKey key) {
        return new ApplicationRole(key, (ImmutableSet<Group>)ImmutableSet.of(), (ImmutableSet<Group>)ImmutableSet.of());
    }

    private ApplicationRole(ApplicationKey key, ImmutableSet<Group> groups, ImmutableSet<Group> defaultGroups) {
        this.key = (ApplicationKey)Assertions.notNull((String)"key", (Object)key);
        this.groups = (ImmutableSet)Assertions.notNull((String)"groups", groups);
        this.defaultGroups = (ImmutableSet)Assertions.notNull((String)"defaultGroups", defaultGroups);
    }

    ApplicationKey key() {
        return this.key;
    }

    Set<Group> groups() {
        return this.groups;
    }

    Set<Group> defaultGroups() {
        return this.defaultGroups;
    }

    ApplicationRole withGroups(Iterable<Group> groups, Iterable<Group> defaultGroups) {
        Assertions.containsNoNulls((String)"groups", groups);
        Assertions.containsNoNulls((String)"defaultGroups", groups);
        ImmutableSet newGroups = ImmutableSet.copyOf(groups);
        ImmutableSet newDefaults = ImmutableSet.copyOf(defaultGroups);
        if (!newGroups.containsAll((Collection)newDefaults)) {
            throw new MigrationFailedException(String.format("Application Role %s is invalid. Trying to set invalid groups %s as default.", this.key, Sets.difference((Set)newDefaults, (Set)newGroups)));
        }
        return new ApplicationRole(this.key, (ImmutableSet<Group>)newGroups, (ImmutableSet<Group>)newDefaults);
    }

    ApplicationRole addGroup(Group group) {
        Assertions.notNull((String)"group", (Object)group);
        if (this.groups.contains((Object)group)) {
            return this;
        }
        ImmutableSet newGroups = ImmutableSet.builder().addAll(this.groups).add((Object)group).build();
        return this.withGroups((Iterable<Group>)newGroups, (Iterable<Group>)this.defaultGroups);
    }

    ApplicationRole addGroups(Iterable<Group> newGroups) {
        Assertions.notNull((String)"newGroups", newGroups);
        ImmutableSet mergedGroups = ImmutableSet.builder().addAll(this.groups).addAll(newGroups).build();
        return this.withGroups((Iterable<Group>)mergedGroups, (Iterable<Group>)this.defaultGroups);
    }

    ApplicationRole addGroupsAsDefault(Iterable<Group> newDefaults) {
        Assertions.notNull((String)"newDefaults", newDefaults);
        ImmutableSet mergedGroups = ImmutableSet.builder().addAll(this.groups).addAll(newDefaults).build();
        ImmutableSet mergedDefaults = ImmutableSet.builder().addAll(this.defaultGroups).addAll(newDefaults).build();
        return this.withGroups((Iterable<Group>)mergedGroups, (Iterable<Group>)mergedDefaults);
    }

    ApplicationRole addGroupAsDefault(Group group) {
        Assertions.notNull((String)"group", (Object)group);
        if (this.groups.contains((Object)group) && this.defaultGroups.contains((Object)group)) {
            return this;
        }
        ImmutableSet newGroups = ImmutableSet.builder().addAll(this.groups).add((Object)group).build();
        ImmutableSet newDefaults = ImmutableSet.builder().addAll(this.defaultGroups).add((Object)group).build();
        return this.withGroups((Iterable<Group>)newGroups, (Iterable<Group>)newDefaults);
    }

    ApplicationRole removeFromDefaults(Group group) {
        Assertions.notNull((String)"group", (Object)group);
        if (!this.groups.contains((Object)group) || !this.defaultGroups.contains((Object)group)) {
            return this;
        }
        return this.withGroups((Iterable<Group>)this.groups, Iterables.filter(this.defaultGroups, g -> !g.equals((Object)group)));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationRole that = (ApplicationRole)o;
        return this.key.equals((Object)that.key) && this.groups.equals(that.groups) && this.defaultGroups.equals(that.defaultGroups);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.groups.hashCode();
        result = 31 * result + this.defaultGroups.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("key", (Object)this.key).append("groups", this.groups).append("defaultGroups", this.defaultGroups).toString();
    }
}

