/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.AbstractNotificationSchemeUpgradeTask;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build801
extends AbstractNotificationSchemeUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build801.class);
    public static final String ID_STRING = "id";
    public static final String NAME_STRING = "name";
    public static final String DESC_STRING = "description";
    public static final String TYPE_STRING = "type";
    private OfBizDelegator ofBizDelegator;
    private EventTypeManager eventTypeManager;
    static final String ISSUE_COMMENT_DELETED_NAME_KEY = "event.type.issuecommentdeleted.name";
    static final String ISSUE_COMMENT_DELETED_DESC_KEY = "event.type.issuecommentdeleted.desc";
    static final String ISSUE_COMMENT_DELETED_NAME = "Issue Comment Deleted";
    static final String ISSUE_COMMENT_DELETED_DESC = "This is the 'Issue Comment Deleted' event type.";

    public UpgradeTask_Build801(OfBizDelegator ofBizDelegator, EventTypeManager eventTypeManager, NotificationSchemeManager notificationSchemeManager) {
        super(notificationSchemeManager);
        this.ofBizDelegator = ofBizDelegator;
        this.eventTypeManager = eventTypeManager;
    }

    @Override
    public String getShortDescription() {
        return "Creates the EventTypes for the ISSUE_COMMENT_DELETED events.";
    }

    @Override
    public String getBuildNumber() {
        return "801";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws DataAccessException, GenericEntityException {
        try {
            GenericValue value = this.ofBizDelegator.findByPrimaryKey("EventType", (Map)FieldMap.build((String)ID_STRING, (Object)EventType.ISSUE_COMMENT_DELETED_ID));
            if (value == null) {
                FieldMap eventTypeParamasMap = FieldMap.build((String)ID_STRING, (Object)EventType.ISSUE_COMMENT_DELETED_ID, (String)NAME_STRING, (Object)this.getI18nTextWithDefault(ISSUE_COMMENT_DELETED_NAME_KEY, ISSUE_COMMENT_DELETED_NAME), (String)DESC_STRING, (Object)this.getI18nTextWithDefault(ISSUE_COMMENT_DELETED_DESC_KEY, ISSUE_COMMENT_DELETED_DESC), (String)TYPE_STRING, (Object)"jira.system.event.type");
                this.ofBizDelegator.createValue("EventType", (Map)eventTypeParamasMap);
            } else {
                log.warn("Not creating 'Comment Deleted' event as it already exists.  This should only happen if this upgrade task is run twice.");
            }
        }
        catch (DataAccessException e) {
            log.error("JIRA was unable to create the new notification event type of 'Issue Comment Deleted' with an id of 16.");
            throw e;
        }
        this.eventTypeManager.clearCache();
        try {
            this.doUpgrade(EventType.ISSUE_UPDATED_ID, EventType.ISSUE_COMMENT_DELETED_ID);
        }
        catch (GenericEntityException e) {
            log.error("Unable to retrieve all notification schemes.", (Throwable)e);
            throw e;
        }
    }

    private String getI18nTextWithDefault(String key, String defaultResult) {
        String result = this.getApplicationI18n().getText(key);
        if (result.equals(key)) {
            return defaultResult;
        }
        return result;
    }

    I18nHelper getApplicationI18n() {
        return new I18nBean();
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "771";
    }
}

