/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.portal.CachingPortletConfigurationStore;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;

public class UpgradeTask_Build70013
extends AbstractImmediateUpgradeTask {
    private static final String ADMIN_DASHBOARD_ITEM_KEY = "com.atlassian.jira.gadgets:admin-dashboard-item";
    private static final String ADMIN_GADGET_XML = "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:admin-gadget/gadgets/admin-gadget.xml";
    private final OfBizDelegator ofBizDelegator;
    private final CachingPortletConfigurationStore cachingPortletConfigurationStore;

    public UpgradeTask_Build70013(OfBizDelegator ofBizDelegator, CachingPortletConfigurationStore cachingPortletConfigurationStore) {
        this.ofBizDelegator = ofBizDelegator;
        this.cachingPortletConfigurationStore = cachingPortletConfigurationStore;
    }

    @Override
    public String getBuildNumber() {
        return "70013";
    }

    @Override
    public String getShortDescription() {
        return "Removing the JIRA Admin gadget.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        try {
            Delete.from("PortletConfiguration").whereLike("dashboardModuleCompleteKey", ADMIN_DASHBOARD_ITEM_KEY).execute(this.ofBizDelegator);
            Delete.from("PortletConfiguration").whereLike("gadgetXml", ADMIN_GADGET_XML).execute(this.ofBizDelegator);
        }
        finally {
            this.cachingPortletConfigurationStore.flush();
        }
    }
}

