/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6325
extends AbstractImmediateUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build6325.class);

    @Override
    public String getBuildNumber() {
        return "6325";
    }

    @Override
    public String getShortDescription() {
        return "Populate project permission entry keys based on ID-s";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Using a static map for a one-time update")
    public void doUpgrade(boolean setupMode) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getDatabaseConnection();
            statement = connection.createStatement();
            StringBuilder sql = new StringBuilder("UPDATE ").append(this.convertToSchemaTableName("schemepermissions")).append(" SET permission_key = (CASE");
            for (Map.Entry entry : LegacyProjectPermissionKeyMapping.ID_TO_KEY.entrySet()) {
                Integer permissionId = (Integer)entry.getKey();
                String permissionKey = ((ProjectPermissionKey)entry.getValue()).permissionKey();
                sql.append(" WHEN permission = ").append(permissionId).append(" THEN '").append(permissionKey).append("'");
            }
            sql.append(" ELSE permission_key END) WHERE scheme IS NOT NULL");
            int updated = statement.executeUpdate(sql.toString());
            LOG.info("Updated {} project permission entries", (Object)updated);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

