/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.GenericValueFunctions;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6322
extends AbstractDelayableUpgradeTask {
    static final String DEFAULT_SUBTASK_AVATAR_FILENAME = "subtask.png";
    static final String DEFAULT_AVATAR_FILENAME = "genericissue.png";
    public static final List<String> ALL_ISSUE_TYPE_ICONS = ImmutableList.of((Object)"genericissue.png", (Object)"all_unassigned.png", (Object)"blank.png", (Object)"bug.png", (Object)"defect.png", (Object)"delete.png", (Object)"documentation.png", (Object)"epic.png", (Object)"exclamation.png", (Object)"health.png", (Object)"improvement.png", (Object)"newfeature.png", (Object[])new String[]{"remove_feature.png", "requirement.png", "sales.png", "story.png", "subtask.png", "subtask_alternate.png", "task.png", "task_agile.png", "undefined.png"});
    private final OfBizDelegator ofBizDelegator;
    private final ApplicationProperties applicationProperties;

    public UpgradeTask_Build6322(OfBizDelegator ofBizDelegator, ApplicationProperties applicationProperties) {
        this.ofBizDelegator = ofBizDelegator;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getBuildNumber() {
        return "6322";
    }

    @Override
    public String getShortDescription() {
        return "Add issue type icons as system avatars";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Iterable nonExistingAvatarFilenames = Iterables.filter(ALL_ISSUE_TYPE_ICONS, this.removeExistingFilenamesFilter());
        Iterable newAvatarGvs = Iterables.transform((Iterable)nonExistingAvatarFilenames, (Function)new AvatarEntityFromFilename());
        for (Map avatarEntity : newAvatarGvs) {
            this.ofBizDelegator.createValue("Avatar", avatarEntity);
        }
        this.storeDefaultIssueAvatarIds();
    }

    private void storeDefaultIssueAvatarIds() {
        long defaultAvatarId = this.getIdOfAvatar(DEFAULT_AVATAR_FILENAME);
        long subtaskDefaultAvatarId = this.getIdOfAvatar(DEFAULT_SUBTASK_AVATAR_FILENAME);
        this.applicationProperties.setString("jira.avatar.issuetype.default.id", String.valueOf(defaultAvatarId));
        this.applicationProperties.setString("jira.avatar.issuetype.subtask.default.id", String.valueOf(subtaskDefaultAvatarId));
    }

    private Predicate<String> removeExistingFilenamesFilter() {
        final Set<String> existingAvatarPaths = this.findExistingSystemAvatarFileNames();
        return new Predicate<String>(){

            public boolean apply(@Nullable String filename) {
                boolean filenameInDatabase = existingAvatarPaths.contains(filename);
                return !filenameInDatabase;
            }
        };
    }

    private long getIdOfAvatar(String avatarFilename) {
        ImmutableMap systemIssueTypeAvatarSearchCriteria = ImmutableMap.builder().put((Object)"systemAvatar", (Object)1).put((Object)"avatarType", (Object)Avatar.Type.ISSUETYPE.getName()).put((Object)"fileName", (Object)avatarFilename).build();
        List defaultIssueTypeAvatar = this.ofBizDelegator.findByAnd("Avatar", (Map)systemIssueTypeAvatarSearchCriteria);
        if (defaultIssueTypeAvatar.size() == 0) {
            throw new RuntimeException("Expected default avatar not found in database: " + systemIssueTypeAvatarSearchCriteria);
        }
        GenericValue firstMatchingAvatar = (GenericValue)defaultIssueTypeAvatar.get(0);
        return firstMatchingAvatar.getLong("id");
    }

    private Set<String> findExistingSystemAvatarFileNames() {
        ImmutableMap systemIssueTypeAvatarSearchCriteria = ImmutableMap.builder().put((Object)"systemAvatar", (Object)1).put((Object)"avatarType", (Object)Avatar.Type.ISSUETYPE.getName()).build();
        List existingSystemAvatars = this.ofBizDelegator.findByAnd("Avatar", (Map)systemIssueTypeAvatarSearchCriteria);
        GenericValueFunctions.GetStringFunction extractItemFileName = GenericValueFunctions.getString("fileName");
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)existingSystemAvatars, (Function)extractItemFileName));
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6321";
    }

    private static class AvatarEntityFromFilename
    implements Function<String, Map<String, Object>> {
        private AvatarEntityFromFilename() {
        }

        public Map<String, Object> apply(String input) {
            ImmutableMap entity = ImmutableMap.builder().put((Object)"fileName", (Object)input).put((Object)"contentType", (Object)"image/png").put((Object)"avatarType", (Object)Avatar.Type.ISSUETYPE.getName()).put((Object)"systemAvatar", (Object)1).build();
            return entity;
        }
    }
}

