/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.util.Visitor;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6152
extends AbstractImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6152.class);
    private EntityEngine entityEngine;

    public UpgradeTask_Build6152(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return "6152";
    }

    @Override
    public String getShortDescription() {
        return "Swaps Cloners links to be in correct direction";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.entityEngine.run(Select.from("IssueLinkType").whereEqual("linkname", "Cloners")).visitWith(new Visitor<GenericValue>(){

            public void visit(GenericValue clonersLinkType) {
                try {
                    UpgradeTask_Build6152.this.swapLinkDirectionsIfLegacy(clonersLinkType.getLong("id"));
                }
                catch (GenericEntityException e) {
                    throw new RuntimeException(e);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Non-constant but safe.")
    private void swapLinkDirectionsIfLegacy(Long linkType) throws GenericEntityException, SQLException {
        try (Connection connection = this.getDatabaseConnection();){
            Statement statement = connection.createStatement();
            ModelEntity issueTable = UpgradeTask_Build6152.getOfBizDelegator().getModelReader().getModelEntity("IssueLink");
            String idColumn = issueTable.getField("id").getColName();
            String linkTypeColumn = issueTable.getField("linktype").getColName();
            String sourceColumn = issueTable.getField("source").getColName();
            String destinationColumn = issueTable.getField("destination").getColName();
            try {
                String update = this.isMYSQL() ? "UPDATE " + this.convertToSchemaTableName("issuelink") + " links1, " + this.convertToSchemaTableName("issuelink") + " links2 " + " SET links1." + sourceColumn + " = links1." + destinationColumn + ", links1." + destinationColumn + " = links2." + sourceColumn + " WHERE links1." + idColumn + " = links2." + idColumn + " AND links1." + linkTypeColumn + " = " + linkType + " AND links1." + sourceColumn + " < links1." + destinationColumn + " AND links1." + sourceColumn + " IS NOT NULL " + " AND links1." + destinationColumn + " IS NOT NULL " : "UPDATE " + this.convertToSchemaTableName("issuelink") + " SET " + sourceColumn + " = " + destinationColumn + ", " + destinationColumn + " = " + sourceColumn + " WHERE " + linkTypeColumn + " = " + linkType + " AND " + sourceColumn + " < " + destinationColumn + " AND " + sourceColumn + " IS NOT NULL " + " AND " + destinationColumn + " IS NOT NULL ";
                int updated = statement.executeUpdate(update);
                log.info(String.format("Swapped %d link(s).", updated));
            }
            finally {
                statement.close();
            }
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6151";
    }
}

