/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6131
extends AbstractImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6131.class);

    @Override
    public String getBuildNumber() {
        return "6131";
    }

    @Override
    public String getShortDescription() {
        return "Removes issue keys from jiraissue table.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        try (Connection connection = this.getDatabaseConnection();){
            String updateSql = "UPDATE " + this.convertToSchemaTableName("jiraissue") + " SET pkey = NULL WHERE pkey IS NOT NULL";
            try (PreparedStatement updateStmt = connection.prepareStatement(updateSql);){
                int updatedCount = updateStmt.executeUpdate();
                log.info(String.format("Updated %d issues.", updatedCount));
            }
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6130";
    }
}

