/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class UpgradeTask_Build6085
extends AbstractImmediateUpgradeTask {
    public static final int BOOLEAN = 1;
    public static final int JIRA_PROPERTIES = 1;
    private EntityEngine entityEngine;
    private OfBizDelegator ofBizDelegator;

    public UpgradeTask_Build6085(EntityEngine entityEngine, OfBizDelegator ofBizDelegator) {
        this.entityEngine = entityEngine;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public String getBuildNumber() {
        return "6085";
    }

    @Override
    public String getShortDescription() {
        return "This upgrade task checks whether the clone link descriptions have been swapped and sets the jira.clone.link.legacy.direction flag to true if they have.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (this.legacyCloneDirectionPropertySet()) {
            return;
        }
        if (this.cloneLinkDirectionsReversed()) {
            this.setLegacyCloneDirectionProperty(true);
        } else {
            this.setLegacyCloneDirectionProperty(false);
        }
    }

    private boolean legacyCloneDirectionPropertySet() {
        Select.WhereContext<GenericValue> idQuery = Select.from("OSPropertyEntry").whereEqual("propertyKey", "jira.clone.link.legacy.direction");
        return !this.entityEngine.run(idQuery).asList().isEmpty();
    }

    private boolean cloneLinkDirectionsReversed() {
        Select.WhereContext<GenericValue> query = Select.from("IssueLinkType").whereEqual("linkname", "Cloners");
        List<GenericValue> clonersList = this.entityEngine.run(query).asList();
        if (clonersList.isEmpty()) {
            return false;
        }
        GenericValue clonersEntry = clonersList.iterator().next();
        return clonersEntry.getString("outward").trim().toLowerCase().equals("is cloned by") || clonersEntry.getString("inward").trim().toLowerCase().equals("clones");
    }

    private void setLegacyCloneDirectionProperty(boolean on) {
        GenericValue propertyEntry = this.ofBizDelegator.createValue("OSPropertyEntry", UtilMisc.toMap((String)"entityId", (Object)1, (String)"entityName", (Object)"jira.properties", (String)"type", (Object)1, (String)"propertyKey", (Object)"jira.clone.link.legacy.direction"));
        this.ofBizDelegator.createValue("OSPropertyNumber", UtilMisc.toMap((String)"id", (Object)propertyEntry.getLong("id"), (String)"value", (Object)(on ? 1 : 0)));
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6083";
    }
}

