/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build602;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserKeyStoreImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class UpgradeTask_Build6040
extends AbstractImmediateUpgradeTask {
    private final EntityEngine entityEngine;

    public UpgradeTask_Build6040(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return "6040";
    }

    @Override
    public String getShortDescription() {
        return "Map existing usernames to userkeys for rename user.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Set<String> mappedUsernames = UpgradeTask_Build6040.getUsernamesThatHaveKeyAlready(this.entityEngine);
        UpgradeTask_Build6040.mapUsersFromCwdUser(this.entityEngine, mappedUsernames);
        UserKeyStoreImpl userKeyStore = (UserKeyStoreImpl)ComponentAccessor.getComponent(UserKeyStore.class);
        userKeyStore.onClearCache(null);
    }

    public static void mapUsernamesToKeys(EntityEngine entityEngine) {
        Set<String> mappedUsernames = UpgradeTask_Build6040.getUsernamesThatHaveKeyAlready(entityEngine);
        UpgradeTask_Build6040.mapUsersFromUserbase(entityEngine, mappedUsernames);
        UpgradeTask_Build6040.mapUsersFromCwdUser(entityEngine, mappedUsernames);
    }

    private static Set<String> getUsernamesThatHaveKeyAlready(EntityEngine entityEngine) {
        List mappedUsernameList = Select.stringColumn("lowerUserName").from(Entity.APPLICATION_USER).runWith(entityEngine).asList();
        return new HashSet<String>(mappedUsernameList);
    }

    private static void mapUsersFromUserbase(EntityEngine entityEngine, Set<String> mappedUsernames) {
        Select.SelectColumnsFromContext<String> selectQuery = Select.distinctString("name").from("OSUser");
        List<String> userNames = entityEngine.run(selectQuery).asList();
        for (String userName : userNames) {
            String lowerUsername = UpgradeTask_Build602.lowerUserName(userName);
            if (mappedUsernames.contains(lowerUsername)) continue;
            UpgradeTask_Build6040.mapUsername(entityEngine, lowerUsername);
        }
    }

    private static void mapUsersFromCwdUser(EntityEngine entityEngine, Set<String> mappedUsernames) {
        Select.SelectColumnsFromContext<String> selectQuery = Select.distinctString("lowerUserName").from("User");
        List<String> lowerUsernames = entityEngine.run(selectQuery).asList();
        for (String lowerUsername : lowerUsernames) {
            if (mappedUsernames.contains(lowerUsername)) continue;
            UpgradeTask_Build6040.mapUsername(entityEngine, lowerUsername);
        }
    }

    private static void mapUsername(EntityEngine entityEngine, String lowerUsername) {
        entityEngine.createValue(Entity.APPLICATION_USER, new ApplicationUserEntity(null, lowerUsername, lowerUsername));
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6039";
    }
}

