/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.jira.upgrade.tasks.AbstractReindexUpgradeTask;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build603
extends AbstractReindexUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build603.class);
    private final CrowdDirectoryService crowdDirectoryService;

    public UpgradeTask_Build603(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Override
    public String getBuildNumber() {
        return "603";
    }

    @Override
    public String getShortDescription() {
        return "Synchronising remote user directories and reindexing all data in JIRA.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (!this.crowdDirectoryService.isDirectorySynchronisable(directory.getId().longValue())) continue;
            LOG.debug("Reindex all data if indexing is turned on.");
            try {
                this.crowdDirectoryService.synchroniseDirectory(directory.getId().longValue(), false);
            }
            catch (OperationFailedException e) {
                LOG.warn("Directory - '" + directory.getName() + "' was not successfully synchronised." + "  You might need to shutdown and restart JIRA after the upgrade completes.");
            }
        }
        super.doUpgrade(setupMode);
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "602";
    }
}

