/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class UpgradeTask_Build572
extends AbstractImmediateUpgradeTask {
    private final OfBizDelegator ofBizDelegator;
    private final ApplicationProperties applicationProperties;

    public UpgradeTask_Build572(OfBizDelegator ofBizDelegator, ApplicationProperties applicationProperties) {
        this.ofBizDelegator = ofBizDelegator;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getBuildNumber() {
        return "572";
    }

    @Override
    public String getShortDescription() {
        return "Initialize a default set of issue link types and turns issue linking on by default";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (setupMode) {
            String cloneName = this.getCloneLinkTypeName();
            ArrayList<LinkDef> linkDefs = new ArrayList<LinkDef>();
            linkDefs.add(new LinkDef("Blocks", "blocks", "is blocked by", null));
            linkDefs.add(new LinkDef(cloneName, "clones", "is cloned by", null));
            linkDefs.add(new LinkDef("Duplicate", "duplicates", "is duplicated by", null));
            linkDefs.add(new LinkDef("Relates", "relates to", "relates to", null));
            for (LinkDef linkDefiniton : linkDefs) {
                List gv = this.ofBizDelegator.findByAnd("IssueLinkType", this.map().add((Object)"linkname", (Object)linkDefiniton.name).toMap());
                if (!gv.isEmpty()) continue;
                this.ofBizDelegator.createValue("IssueLinkType", this.map().add((Object)"linkname", (Object)linkDefiniton.name).add((Object)"outward", (Object)linkDefiniton.outward).add((Object)"inward", (Object)linkDefiniton.inward).add((Object)"style", (Object)linkDefiniton.style).toMap());
            }
            this.applicationProperties.setOption("jira.option.issuelinking", true);
        }
    }

    private String getCloneLinkTypeName() {
        String name = this.applicationProperties.getDefaultBackedString("jira.clone.linktype.name");
        return name == null ? "Cloners" : name;
    }

    private MapBuilder<String, Object> map() {
        return MapBuilder.newBuilder();
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "571";
    }

    private static class LinkDef {
        private final String name;
        private final String outward;
        private final String inward;
        private final String style;

        private LinkDef(String name, String outward, String inward, String style) {
            this.name = name;
            this.outward = outward;
            this.inward = inward;
            this.style = style;
        }
    }
}

