/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.FormattedLogMsg;
import com.atlassian.jira.startup.PluginInfo;
import com.atlassian.jira.startup.PluginInfos;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;

public class PluginInfosImpl
implements PluginInfos {
    private final String name;
    private final ImmutableList<PluginInfo> pluginInfos;

    public PluginInfosImpl(String name, Iterable<PluginInfo> pluginInfos) {
        this.name = (String)Assertions.notNull((Object)name);
        this.pluginInfos = ImmutableList.copyOf(pluginInfos);
    }

    public String name() {
        return this.name;
    }

    public Iterator<PluginInfo> iterator() {
        return this.pluginInfos.iterator();
    }

    public int size() {
        return this.pluginInfos.size();
    }

    public String toString() {
        return PluginInfosImpl.class.getSimpleName() + "[\"" + this.name() + "\"]";
    }

    public String prettyPrint() {
        FormattedLogMsg logMsg = new FormattedLogMsg();
        logMsg.outputHeader(this.name());
        logMsg.outputProperty("Number", String.valueOf(this.size()), 1);
        for (PluginInfo pluginInfo : this.pluginInfos) {
            logMsg.add("");
            logMsg.outputProperty(pluginInfo.getName(), pluginInfo.getKey(), 1);
            logMsg.outputProperty("Version", pluginInfo.getPluginInformation().getVersion(), 2);
            logMsg.outputProperty("Status", pluginInfo.isEnabled() ? "enabled" : "disabled", 2);
            if (pluginInfo.isUnloadable()) {
                logMsg.outputProperty("Unloadable Reason", pluginInfo.getUnloadableReason(), 2);
            }
            logMsg.outputProperty("Vendor", pluginInfo.getPluginInformation().getVendorName(), 2);
            logMsg.outputProperty("Description", pluginInfo.getPluginInformation().getDescription(), 2);
        }
        return logMsg.toString();
    }
}

