/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleComparator;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class DefaultProjectRoleManager
implements ProjectRoleManager {
    private ProjectRoleAndActorStore projectRoleAndActorStore;

    public DefaultProjectRoleManager(ProjectRoleAndActorStore projectRoleAndActorStore) {
        this.projectRoleAndActorStore = projectRoleAndActorStore;
    }

    public Collection<ProjectRole> getProjectRoles() {
        return this.projectRoleAndActorStore.getAllProjectRoles();
    }

    public Collection<ProjectRole> getProjectRoles(ApplicationUser user, Project project) {
        TreeSet<ProjectRole> associatedProjectRoles = new TreeSet<ProjectRole>(ProjectRoleComparator.COMPARATOR);
        Collection<ProjectRole> allProjectRoles = this.getProjectRoles();
        for (ProjectRole projectRole : allProjectRoles) {
            ProjectRoleActors projectRoleActors = this.getProjectRoleActors(projectRole, project);
            if (!projectRoleActors.contains(user)) continue;
            associatedProjectRoles.add(projectRole);
        }
        return associatedProjectRoles;
    }

    public ProjectRole getProjectRole(Long id) {
        return this.projectRoleAndActorStore.getProjectRole(id);
    }

    public ProjectRole getProjectRole(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("ProjectRole can not be found with a null name");
        }
        return this.projectRoleAndActorStore.getProjectRoleByName(name);
    }

    public ProjectRole createRole(ProjectRole projectRole) {
        if (projectRole == null || projectRole.getName() == null) {
            throw new IllegalArgumentException("ProjectRole can not be created with a null name");
        }
        if (this.isRoleNameUnique(projectRole.getName())) {
            return this.projectRoleAndActorStore.addProjectRole(projectRole);
        }
        throw new IllegalArgumentException("A project role with the provided name: " + projectRole.getName() + ", already exists in the system.");
    }

    public boolean isRoleNameUnique(String name) {
        return this.projectRoleAndActorStore.getProjectRoleByName(name) == null;
    }

    public void deleteRole(ProjectRole projectRole) {
        if (projectRole == null) {
            throw new IllegalArgumentException("ProjectRole can not be null");
        }
        this.projectRoleAndActorStore.deleteProjectRole(projectRole);
    }

    public void updateRole(ProjectRole projectRole) {
        if (projectRole == null) {
            throw new IllegalArgumentException("ProjectRole can not be null");
        }
        if (projectRole.getName() == null) {
            throw new IllegalArgumentException("ProjectRole name can not be null");
        }
        this.projectRoleAndActorStore.updateProjectRole(projectRole);
    }

    public ProjectRoleActors getProjectRoleActors(ProjectRole projectRole, Project project) {
        if (projectRole == null) {
            throw new IllegalArgumentException("ProjectRole can not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Project can not be null");
        }
        return this.projectRoleAndActorStore.getProjectRoleActors(projectRole.getId(), project.getId());
    }

    public void updateProjectRoleActors(ProjectRoleActors projectRoleActors) {
        if (projectRoleActors == null) {
            throw new IllegalArgumentException("ProjectRoleActors can not be null");
        }
        if (projectRoleActors.getProjectId() == null) {
            throw new IllegalArgumentException("ProjectRoleActors project can not be null");
        }
        if (projectRoleActors.getProjectRoleId() == null) {
            throw new IllegalArgumentException("ProjectRoleActors projectRole can not be null");
        }
        if (projectRoleActors.getRoleActors() == null) {
            throw new IllegalArgumentException("ProjectRoleActors roleActors set can not be null");
        }
        this.projectRoleAndActorStore.updateProjectRoleActors(projectRoleActors);
    }

    public DefaultRoleActors getDefaultRoleActors(ProjectRole projectRole) {
        if (projectRole == null) {
            throw new IllegalArgumentException("ProjectRole can not be null");
        }
        return this.projectRoleAndActorStore.getDefaultRoleActors(projectRole.getId());
    }

    public void updateDefaultRoleActors(DefaultRoleActors defaultRoleActors) {
        if (defaultRoleActors == null) {
            throw new IllegalArgumentException("DefaultRoleActors can not be null");
        }
        if (defaultRoleActors.getProjectRoleId() == null) {
            throw new IllegalArgumentException("DefaultRoleActors projectRole can not be null");
        }
        if (defaultRoleActors.getRoleActors() == null) {
            throw new IllegalArgumentException("DefaultRoleActors roleActors set can not be null");
        }
        this.projectRoleAndActorStore.updateDefaultRoleActors(defaultRoleActors);
    }

    public void applyDefaultsRolesToProject(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Project can not be null");
        }
        this.projectRoleAndActorStore.applyDefaultsRolesToProject(project);
    }

    public void removeAllRoleActorsByNameAndType(String key, String type) {
        if (key == null) {
            throw new IllegalArgumentException("The role actor name can not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("The role type can not be null");
        }
        this.projectRoleAndActorStore.removeAllRoleActorsByKeyAndType(key, type);
    }

    public void removeAllRoleActorsByProject(Project project) {
        if (project == null || project.getId() == null) {
            throw new IllegalArgumentException("The project id can not be null");
        }
        this.projectRoleAndActorStore.removeAllRoleActorsByProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserInProjectRole(ApplicationUser user, ProjectRole projectRole, Project project) {
        try {
            UtilTimerStack.push((String)"DefaultProjectRoleManager.isUserInProjectRole");
            if (project == null || project.getId() == null) {
                throw new IllegalArgumentException("The project id can not be null");
            }
            if (projectRole == null) {
                throw new IllegalArgumentException("ProjectRole can not be null");
            }
            boolean bl = this.getProjectRoleActors(projectRole, project).contains(user);
            return bl;
        }
        finally {
            UtilTimerStack.pop((String)"DefaultProjectRoleManager.isUserInProjectRole");
        }
    }

    public Collection<Long> getProjectIdsContainingRoleActorByNameAndType(String key, String type) {
        if (key == null) {
            throw new IllegalArgumentException("The role actor name can not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("The role type can not be null");
        }
        return this.projectRoleAndActorStore.getProjectIdsContainingRoleActorByKeyAndType(key, type);
    }

    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter) {
        return this.projectRoleAndActorStore.roleActorOfTypeExistsForProjects(projectsToLimitBy, projectRole, projectRoleType, projectRoleParameter);
    }

    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userName) {
        return this.projectRoleAndActorStore.getProjectIdsForUserInGroupsBecauseOfRole(projectsToLimitBy, projectRole, projectRoleType, userName);
    }

    public ProjectRoleManager.ProjectIdToProjectRoleIdsMap createProjectIdToProjectRolesMap(ApplicationUser user, Collection<Long> projectIds) {
        ProjectRoleManager.ProjectIdToProjectRoleIdsMap map = new ProjectRoleManager.ProjectIdToProjectRoleIdsMap();
        if (projectIds != null && !projectIds.isEmpty()) {
            ProjectManager projectManager = ComponentAccessor.getProjectManager();
            for (Long projectId : projectIds) {
                Collection<ProjectRole> projectRoles = this.getProjectRoles(user, projectManager.getProjectObj(projectId));
                for (ProjectRole projectRole : projectRoles) {
                    map.add(projectId, projectRole.getId());
                }
            }
        }
        return map;
    }
}

