/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.scheduler.Quartz1ClassLoadHelper;
import com.atlassian.jira.scheduler.Quartz1ConnectionProvider;
import com.atlassian.scheduler.quartz1.Quartz1DefaultSettingsFactory;
import com.atlassian.scheduler.quartz1.spi.Quartz1SchedulerConfiguration;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;
import org.quartz.simpl.ZeroSizeThreadPool;

public class JiraQuartz1SchedulerConfiguration
implements Quartz1SchedulerConfiguration {
    private static final String PREFIX = "JQUARTZ_";
    private final ApplicationProperties applicationProperties;
    private final DelegatorInterface delegatorInterface;

    public JiraQuartz1SchedulerConfiguration(ApplicationProperties applicationProperties, DelegatorInterface delegatorInterface) {
        this.applicationProperties = applicationProperties;
        this.delegatorInterface = delegatorInterface;
    }

    @Nonnull
    public Properties getLocalSettings() {
        return JiraQuartz1SchedulerConfiguration.killThreadPool(Quartz1DefaultSettingsFactory.getDefaultLocalSettings());
    }

    @Nonnull
    public Properties getClusteredSettings() {
        Properties clusteredProperties = Quartz1DefaultSettingsFactory.getDefaultClusteredSettings();
        clusteredProperties.setProperty("org.quartz.jobStore.tablePrefix", this.getTablePrefix());
        clusteredProperties.setProperty("org.quartz.jobStore.dataSource", "JiraDataSource");
        clusteredProperties.setProperty("org.quartz.jobStore.driverDelegateClass", JiraQuartz1SchedulerConfiguration.getDelegateClassName());
        clusteredProperties.setProperty("org.quartz.dataSource.JiraDataSource.connectionProvider.class", Quartz1ConnectionProvider.class.getName());
        clusteredProperties.setProperty("org.quartz.scheduler.classLoadHelper.class", Quartz1ClassLoadHelper.class.getName());
        clusteredProperties.setProperty("org.quartz.jobStore.isClustered", "false");
        clusteredProperties.setProperty("org.quartz.scheduler.instanceId", "NotUsed");
        return JiraQuartz1SchedulerConfiguration.killThreadPool(clusteredProperties);
    }

    private static Properties killThreadPool(Properties properties) {
        properties.setProperty("org.quartz.threadPool.class", ZeroSizeThreadPool.class.getName());
        properties.remove("org.quartz.threadPool.threadCount");
        properties.remove("org.quartz.threadPool.threadPriority");
        return properties;
    }

    private String getTablePrefix() {
        String schemaName = this.getSchemaName();
        String tablePrefix = StringUtils.isEmpty((String)schemaName) ? PREFIX : schemaName + '.' + PREFIX;
        return tablePrefix;
    }

    protected String getSchemaName() {
        GenericHelper helper;
        try {
            helper = this.delegatorInterface.getEntityHelper("User");
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return EntityConfigUtil.getInstance().getDatasourceInfo(helper.getHelperName()).getSchemaName();
    }

    @Nullable
    public TimeZone getDefaultTimeZone() {
        String zoneId = this.applicationProperties.getString("jira.default.timezone");
        return zoneId != null ? TimeZone.getTimeZone(zoneId) : null;
    }

    private static String getDelegateClassName() {
        String string;
        Connection connection = new Quartz1ConnectionProvider().getConnection();
        if (connection == null) {
            throw new DataAccessException("Unable to obtain a DB connection");
        }
        try {
            string = JiraQuartz1SchedulerConfiguration.getDatabaseDelegate(DatabaseTypeFactory.getTypeForConnection((Connection)connection));
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new DataAccessException("Unable to obtain a DB connection", (Throwable)e);
            }
        }
        connection.close();
        return string;
    }

    private static String getDatabaseDelegate(DatabaseType type) {
        if (type == DatabaseTypeFactory.DB2) {
            return "org.quartz.impl.jdbcjobstore.DB2v8Delegate";
        }
        if (type == DatabaseTypeFactory.CLOUDSCAPE) {
            return "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
        }
        if (type == DatabaseTypeFactory.HSQL) {
            return "org.quartz.impl.jdbcjobstore.HSQLDBDelegate";
        }
        if (type == DatabaseTypeFactory.H2) {
            return "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
        }
        if (type == DatabaseTypeFactory.MYSQL) {
            return "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
        }
        if (type == DatabaseTypeFactory.MSSQL) {
            return "org.quartz.impl.jdbcjobstore.MSSQLDelegate";
        }
        if (type == DatabaseTypeFactory.ORACLE_10G) {
            return "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
        }
        if (type == DatabaseTypeFactory.ORACLE_8I) {
            return "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
        }
        if (type == DatabaseTypeFactory.POSTGRES_7_2) {
            return "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
        }
        if (type == DatabaseTypeFactory.POSTGRES_7_3) {
            return "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
        }
        if (type == DatabaseTypeFactory.POSTGRES) {
            return "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
        }
        if (type == DatabaseTypeFactory.SYBASE) {
            return "org.quartz.impl.jdbcjobstore.SybaseDelegate";
        }
        return "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
    }
}

