/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.application.host.plugin.PluginApplicationMetaDataManager;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.JiraApplication;
import com.atlassian.jira.application.JiraPluginApplicationMetaData;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JiraApplicationAdapter {
    private static final ProjectTypeKey BUSINESS_KEY = new ProjectTypeKey("business");
    private static final String BUSINESS_DESC = "jira.project.type.business.description";
    private static final String BUSINESS_ICON = "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAxOC4xLjEsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCINCgkgdmlld0JveD0iMCAwIDE4IDE4IiBlbmFibGUtYmFja2dyb3VuZD0ibmV3IDAgMCAxOCAxOCIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+DQo8ZyBpZD0iTGF5ZXJfMiI+DQoJPHBhdGggZmlsbD0iIzM1NzJCMCIgZD0iTTksMEM0LDAsMCw0LDAsOWMwLDUsNCw5LDksOXM5LTQsOS05QzE4LDQsMTQsMCw5LDB6IE0xMCwxM0g1di0xaDVWMTN6IE0xMywxMUg1di0xaDhWMTF6IE0xMyw5SDVWOGg4Vjl6DQoJCSBNMTMsN0g1VjZoOFY3eiIvPg0KPC9nPg0KPC9zdmc+";
    private static final String BUSINESS_COLOR = "#1D8832";
    private static final int BUSINESS_WEIGHT = 1000;
    static final ProjectType BUSINESS_TYPE = new ProjectType(BUSINESS_KEY, "jira.project.type.business.description", "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAxOC4xLjEsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCINCgkgdmlld0JveD0iMCAwIDE4IDE4IiBlbmFibGUtYmFja2dyb3VuZD0ibmV3IDAgMCAxOCAxOCIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+DQo8ZyBpZD0iTGF5ZXJfMiI+DQoJPHBhdGggZmlsbD0iIzM1NzJCMCIgZD0iTTksMEM0LDAsMCw0LDAsOWMwLDUsNCw5LDksOXM5LTQsOS05QzE4LDQsMTQsMCw5LDB6IE0xMCwxM0g1di0xaDVWMTN6IE0xMywxMUg1di0xaDhWMTF6IE0xMyw5SDVWOGg4Vjl6DQoJCSBNMTMsN0g1VjZoOFY3eiIvPg0KPC9nPg0KPC9zdmc+", "#1D8832", 1000);
    public final ApplicationManager applicationManager;
    public final PluginApplicationMetaDataManager metaDataManager;
    public final ApplicationAuthorizationService applicationAuthorizationService;

    public JiraApplicationAdapter(ApplicationManager applicationManager, PluginApplicationMetaDataManager metaDataManager, ApplicationAuthorizationService applicationAuthorizationService) {
        this.applicationManager = applicationManager;
        this.metaDataManager = metaDataManager;
        this.applicationAuthorizationService = applicationAuthorizationService;
    }

    public Iterable<JiraApplication> getJiraApplications() {
        return (Iterable)this.buildJiraApplications().collect(CollectorsUtil.toImmutableList());
    }

    public Iterable<JiraApplication> getAccessibleJiraApplications(ApplicationUser user) {
        return (Iterable)this.buildJiraApplications().filter(jiraApplication -> this.applicationAuthorizationService.canUseApplication(user, jiraApplication.getKey())).collect(CollectorsUtil.toImmutableList());
    }

    private Stream<JiraApplication> buildJiraApplications() {
        return Stream.concat(this.getJiraAppForPlatformApp(), this.getJiraAppsForNonPlatformApps());
    }

    private Stream<JiraApplication> getJiraAppForPlatformApp() {
        PlatformApplication platform = this.applicationManager.getPlatform();
        return Stream.of(new JiraApplication((Application)platform, Arrays.asList(BUSINESS_TYPE)));
    }

    private Stream<JiraApplication> getJiraAppsForNonPlatformApps() {
        return this.getNonPlatformApplications().flatMap(this::getJiraApplicationFor);
    }

    private Stream<Application> getNonPlatformApplications() {
        Stream<Application> applications = StreamSupport.stream(this.applicationManager.getApplications().spliterator(), false);
        return applications.filter(input -> !(input instanceof PlatformApplication));
    }

    private Stream<JiraApplication> getJiraApplicationFor(Application application) {
        return (Stream)this.getMetadataForApplication(application.getKey()).map(meta -> new JiraApplication(application, meta.getProjectTypes())).map(Stream::of).getOrElse(Stream.empty());
    }

    private Option<JiraPluginApplicationMetaData> getMetadataForApplication(ApplicationKey appKey) {
        return this.metaDataManager.getApplication(appKey).map(JiraPluginApplicationMetaData.class::cast);
    }
}

