/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class JiraWebResourceBatchingConfiguration
implements ResourceBatchingConfiguration {
    public static final String PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING = "plugin.webresource.batch.content.tracking".toString();
    private static final String USER_AGENT = "USER-AGENT";
    private final List<String> resources;
    private final JiraProperties jiraSystemProperties;

    public JiraWebResourceBatchingConfiguration(JiraProperties jiraSystemProperties, FeatureManager featureManager) {
        this.jiraSystemProperties = jiraSystemProperties;
        ImmutableList.Builder resourcesBuilder = ImmutableList.builder().add((Object)"jira.webresources:superbatch-default");
        if (featureManager.isEnabled("plugin.webresource.batch.timezone")) {
            resourcesBuilder.add((Object)"com.atlassian.jira.jira-tzdetect-plugin:tzdetect-lib");
        }
        this.resources = resourcesBuilder.build();
    }

    public boolean isSuperBatchingEnabled() {
        return !this.resources.isEmpty() && !this.jiraSystemProperties.isSuperBatchingDisabled() || this.forceBatchingInThisRequest();
    }

    public boolean isContextBatchingEnabled() {
        return !this.jiraSystemProperties.isDevMode() || this.forceBatchingInThisRequest();
    }

    public boolean isPluginWebResourceBatchingEnabled() {
        boolean forced = this.forceBatchingInThisRequest();
        if (forced) {
            return true;
        }
        if (this.jiraSystemProperties.getProperty("plugin.webresource.batching.off") != null) {
            return !Boolean.parseBoolean(this.jiraSystemProperties.getProperty("plugin.webresource.batching.off"));
        }
        return !this.jiraSystemProperties.isDevMode();
    }

    public List<String> getSuperBatchModuleCompleteKeys() {
        return this.resources;
    }

    public boolean isJavaScriptTryCatchWrappingEnabled() {
        return this.jiraSystemProperties.getBoolean("plugin.webresource.javascript.try.catch.wrapping");
    }

    public boolean isBatchContentTrackingEnabled() {
        return this.jiraSystemProperties.getBoolean(PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING);
    }

    public boolean resplitMergedContextBatchesForThisRequest() {
        return this.isCurrentRequestIE();
    }

    private boolean forceBatchingInThisRequest() {
        return this.jiraSystemProperties.isDevMode() && this.isCurrentRequestIE();
    }

    private boolean isCurrentRequestIE() {
        HttpServletRequest httpRequest = ExecutingHttpRequest.get();
        if (httpRequest == null) {
            return false;
        }
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        String userAgent = httpRequest.getHeader(USER_AGENT);
        UserAgentUtil.UserAgent userAgentInfo = userAgentUtil.getUserAgentInfo(userAgent);
        return userAgentInfo.getBrowser().getBrowserFamily().equals((Object)UserAgentUtil.BrowserFamily.MSIE) || userAgentInfo.getBrowser().getBrowserFamily().equals((Object)UserAgentUtil.BrowserFamily.IE);
    }
}

