/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class JiraBaseUrlCDNStrategy
implements CDNStrategy {
    static final String ENABLED_FEATURE_KEY = "jira.baseurl.cdn.enabled";
    static final String PREFIX_SYSTEM_PROPERTY = "jira.baseurl.cdn.prefix";
    private final JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();
    private final ApplicationProperties applicationProperties;

    public JiraBaseUrlCDNStrategy(ApplicationProperties applicationProperties) {
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
    }

    public boolean supportsCdn() {
        return !StringUtils.isBlank((String)this.getPrefix());
    }

    public String transformRelativeUrl(String s) {
        return this.getPrefix() + s;
    }

    private String getPrefix() {
        String prefix = this.jiraSystemProperties.getProperty(PREFIX_SYSTEM_PROPERTY);
        if (null == prefix) {
            return null;
        }
        try {
            String baseUrl = this.applicationProperties.getString("jira.baseurl");
            String authority = new URL(baseUrl).getAuthority();
            return prefix + "/" + authority;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }
}

