/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class CacheableContextProviderDecorator
implements ContextProvider {
    @VisibleForTesting
    static final String REQUEST_ATTRIBUTE_PREFIX = "com.atlassian.jira.request.scoped.context.provider:";
    private final CacheableContextProvider contextProvider;

    public CacheableContextProviderDecorator(CacheableContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        String key = REQUEST_ATTRIBUTE_PREFIX + this.contextProvider.getClass().getName() + ":" + this.contextProvider.getUniqueContextKey(context);
        HttpServletRequest request = this.getRequest(context);
        if (request != null) {
            Map<String, Object> generatedContext = (Map<String, Object>)request.getAttribute(key);
            if (generatedContext == null) {
                generatedContext = this.initContextMap(context);
                request.setAttribute(key, generatedContext);
            }
            return new HashMap<String, Object>(generatedContext);
        }
        return this.initContextMap(context);
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.contextProvider.init(params);
    }

    private Map<String, Object> initContextMap(Map<String, Object> context) {
        return this.contextProvider.getContextMap(context);
    }

    protected HttpServletRequest getRequest(Map<String, Object> context) {
        HttpServletRequest request;
        JiraHelper jiraHelper = (JiraHelper)context.get("helper");
        if (jiraHelper != null && (request = jiraHelper.getRequest()) != null) {
            return request;
        }
        Object o = context.get("request");
        if (o != null && o instanceof HttpServletRequest) {
            request = (HttpServletRequest)o;
            return request;
        }
        request = ExecutingHttpRequest.get();
        if (request != null) {
            return request;
        }
        return ActionContext.getRequest();
    }
}

