/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report;

import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.AbstractConfigurableModuleDescriptor;
import com.atlassian.jira.plugin.PluginInjector;
import com.atlassian.jira.plugin.report.Report;
import com.atlassian.jira.plugin.report.ReportCategory;
import com.atlassian.jira.plugin.report.ReportCategoryImpl;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.plugin.report.ReportUrlProvider;
import com.atlassian.jira.plugin.webfragment.descriptors.ConditionDescriptorFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.atlassian.query.Query;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ReportModuleDescriptorImpl
extends AbstractConfigurableModuleDescriptor<Report>
implements ReportModuleDescriptor,
ConditionalDescriptor {
    public static final String PARAMS_PATTERN = "{0}?selectedProjectId={1,number,#}&projectOrFilterId=project-{1,number,#}&projectOrFilterName={2}&reportKey={3}";
    public static final int DEFAULT_WEIGHT = 1000;
    public static final String DEFAULT_THUMBNAIL_CSS_CLASS = "default-thumbnail";
    private Report report;
    private String label = "Unknown";
    private String url = "/secure/ConfigureReport!default.jspa";
    private String labelKey;
    private ReportCategory category = ReportCategoryImpl.OTHER;
    private String thumbnailCssClass = "default-thumbnail";
    private int weight = 1000;
    private String urlProviderClass;
    private ReportUrlProvider urlProvider;
    private Condition condition;
    private final ConditionDescriptorFactory conditionDescFactory;

    @Deprecated
    public ReportModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        this(authenticationContext, moduleFactory, (ConditionDescriptorFactory)ComponentAccessor.getComponent(ConditionDescriptorFactory.class));
    }

    public ReportModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, ConditionDescriptorFactory conditionDescFactory) {
        super(authenticationContext, moduleFactory);
        this.conditionDescFactory = conditionDescFactory;
    }

    protected boolean isSingletonByDefault() {
        return false;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        String clazz;
        Element categoryEl;
        Element urlEl;
        super.init(plugin, element);
        Element labelEl = element.element("label");
        if (labelEl != null) {
            if (labelEl.attribute("key") != null) {
                this.labelKey = labelEl.attributeValue("key");
            } else {
                this.label = labelEl.getTextTrim();
            }
        }
        if ((urlEl = element.element("url")) != null) {
            String stringUrl = urlEl.getTextTrim();
            if (StringUtils.isNotBlank((String)stringUrl)) {
                this.url = stringUrl;
            }
            this.urlProviderClass = StringUtils.trimToNull((String)urlEl.attributeValue("provider"));
        }
        if ((categoryEl = element.element("category")) != null) {
            String categoryKey = StringUtils.trimToNull((String)categoryEl.attributeValue("key"));
            ReportCategory reportCategory = ReportCategoryImpl.byKey(categoryKey);
            if (reportCategory != null) {
                this.category = reportCategory;
            } else {
                throw new PluginParseException(String.format("The report module: %s specified a category key that is not a valid category: %s", this.getCompleteKey(), categoryKey));
            }
        }
        try {
            String weightString = StringUtils.trimToNull((String)element.attributeValue("weight"));
            if (weightString != null) {
                this.weight = Integer.parseInt(weightString);
            }
        }
        catch (NumberFormatException e) {
            throw new PluginParseException(String.format("The report module: %s specified a weight attribute that is not an integer", this.getCompleteKey()), (Throwable)e);
        }
        Element thumbnail = element.element("thumbnail");
        if (thumbnail != null && (clazz = StringUtils.trimToNull((String)thumbnail.attributeValue("cssClass"))) != null) {
            this.thumbnailCssClass = clazz;
        }
        this.condition = this.conditionDescFactory.retrieveCondition(plugin, element);
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(Report.class);
        if (this.urlProviderClass != null && this.urlProvider == null) {
            try {
                Class loadedClass = this.plugin.loadClass(this.urlProviderClass, ((Object)((Object)this)).getClass());
                if (!ReportUrlProvider.class.isAssignableFrom(loadedClass)) {
                    throw new PluginParseException("Provided class " + this.urlProviderClass + " does not implement ReportUrlProvider interface");
                }
                try {
                    this.urlProvider = (ReportUrlProvider)PluginInjector.newInstance(loadedClass, this.plugin);
                }
                catch (Exception e) {
                    throw new PluginParseException("Cannot instantiate url provider class: " + this.urlProviderClass, (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Cannot load url provider class: " + this.urlProviderClass, (Throwable)e);
            }
        }
    }

    @Override
    public Report getModule() {
        if (!this.isSingleton()) {
            return this.makeModule();
        }
        if (this.report == null) {
            this.report = this.makeModule();
        }
        return this.report;
    }

    private Report makeModule() {
        Plugin plugin = this.getPlugin();
        Report reportModule = plugin instanceof ContainerManagedPlugin ? (Report)((ContainerManagedPlugin)plugin).getContainerAccessor().createBean(this.getModuleClass()) : (Report)JiraUtils.loadComponent(this.getModuleClass());
        reportModule.init((ReportModuleDescriptor)this);
        return reportModule;
    }

    public String getLabel() {
        if (this.labelKey != null) {
            return this.getI18nBean().getText(this.labelKey);
        }
        return this.label;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public String getUrl(Project context) {
        Option<String> reportUrl = this.getUrl((Map<String, Object>)ImmutableMap.of((Object)"project", (Object)context));
        if (reportUrl.isDefined()) {
            return (String)reportUrl.get();
        }
        return this.getProjectIssuesNavUrl(context);
    }

    private String getProjectIssuesNavUrl(Project project) {
        Query projectQuery = JqlQueryBuilder.newBuilder().where().project(new String[]{project.getKey()}).buildQuery();
        return SearchRequestViewUtils.getLink(new SearchRequest(projectQuery), "", this.getAuthenticationContext().getUser());
    }

    public Option<String> getUrl(final Map<String, Object> context) {
        if (this.urlProvider != null) {
            return SafePluginPointAccess.call((Callable)new Callable<Option<String>>(){

                @Override
                public Option<String> call() throws Exception {
                    return ReportModuleDescriptorImpl.this.urlProvider.getUrl((ReportModuleDescriptor)ReportModuleDescriptorImpl.this, context);
                }
            }).flatMap(Functions.identity());
        }
        Project project = (Project)context.get("project");
        return Option.option((Object)MessageFormat.format(PARAMS_PATTERN, this.url, project.getId(), project.getName(), this.getCompleteKey()));
    }

    public ReportCategory getCategory() {
        return this.category;
    }

    public String getThumbnailCssClass() {
        return this.thumbnailCssClass;
    }

    public int getWeight() {
        return this.weight;
    }

    public Condition getCondition() {
        return this.condition;
    }
}

