/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.impl;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.NullResolutionComparator;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.componentpanel.BrowseComponentContext;
import com.atlassian.jira.plugin.projectpanel.impl.VersionDrillDownRenderer;
import com.atlassian.jira.plugin.util.TabPanelUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.bean.PercentageGraphModel;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;

public class VersionDrillDownRendererImpl
implements VersionDrillDownRenderer {
    private static final Logger log = LoggerFactory.getLogger(VersionDrillDownRendererImpl.class);
    public static final int SUBSET_SIZE = 10;
    private static final String CONTENT_ONLY = "contentOnly";
    public static final String EXPAND_VERSION = "expandVersion";
    public static final String COLLAPSE_VERSION = "collapseVersion";
    public static final String ALL_VERSIONS = "allVersions";
    private final JiraAuthenticationContext authenticationContext;
    private final VersionManager versionManager;
    private final SearchProvider searchProvider;
    private final VelocityTemplatingEngine templatingEngine;
    private final SearchService searchService;
    private final ConstantsManager constantsManager;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public VersionDrillDownRendererImpl(JiraAuthenticationContext authenticationContext, VersionManager versionManager, ConstantsManager constantsManager, SearchProvider searchProvider, VelocityTemplatingEngine templatingEngine, SearchService searchService, FieldVisibilityManager fieldVisibilityManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.authenticationContext = authenticationContext;
        this.versionManager = versionManager;
        this.constantsManager = constantsManager;
        this.searchProvider = searchProvider;
        this.templatingEngine = templatingEngine;
        this.searchService = searchService;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    @Override
    public String getHtml(BrowseContext ctx, String uniqueKey, Collection<Version> versions) {
        Map<String, Object> params = this.createVelocityParams(ctx, uniqueKey, versions);
        try {
            return this.templatingEngine.render(TemplateSources.file((String)"templates/plugins/jira/projectpanels/roadmap-panel.vm")).applying(params).asHtml();
        }
        catch (VelocityException e) {
            log.error("Error occurred while rendering velocity template: 'templates/plugins/jira/projectpanels/roadmap-panel.vm'.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> createVelocityParams(BrowseContext ctx, String uniqueKey, Collection<Version> versions) {
        Version expandingVersion;
        Map<String, Object> startingParams = ctx.createParameterMap();
        startingParams = JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
        boolean isExpanding = this.getPassedParameter(EXPAND_VERSION) != null;
        boolean isCollapsing = this.getPassedParameter(COLLAPSE_VERSION) != null;
        boolean isContentOnly = Boolean.valueOf(this.getPassedParameter(CONTENT_ONLY));
        startingParams.put("renderer", this);
        startingParams.put("reportKey", uniqueKey);
        startingParams.put("versionHelper", new VersionHelperBean(ctx, this.searchProvider));
        startingParams.put("versionManager", this.versionManager);
        startingParams.put("isExpanding", isExpanding);
        startingParams.put("isCollapsing", isCollapsing);
        startingParams.put("isContentOnly", isContentOnly);
        startingParams.put("selectedVersions", this.getSelectedVersions(ctx, uniqueKey));
        boolean showAllVersions = this.showAllVersions(ctx, uniqueKey);
        startingParams.put("versions", this.trimVersions(versions, showAllVersions));
        if (isContentOnly && isExpanding && versions.contains(expandingVersion = this.versionManager.getVersion(Long.valueOf(this.getPassedParameter(EXPAND_VERSION))))) {
            startingParams.put("expandingVersion", expandingVersion);
        }
        startingParams.put("graphingBean", new RoadMapGraphingBean(ctx, this.searchProvider, this.constantsManager, this.searchService));
        startingParams.put("versionSubsetSize", 10);
        startingParams.put("showAllVersions", showAllVersions);
        startingParams.put("isBigList", versions.size() > 10);
        startingParams.put("i18n", new I18nBean(ctx.getUser()));
        startingParams.put("fieldVisibility", this.fieldVisibilityManager);
        return startingParams;
    }

    @Override
    public String getNavigatorUrl(Project project, Version version, ProjectComponent component) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().defaultAnd();
        if (project != null) {
            builder.project(new String[]{project.getKey()});
        }
        if (version != null) {
            builder.fixVersion(version.getName());
        }
        if (component != null) {
            builder.component(new String[]{component.getName()});
        }
        return this.searchService.getQueryString(this.authenticationContext.getUser(), builder.buildQuery());
    }

    private Collection<Version> trimVersions(Collection<Version> versions, boolean showAllVersions) {
        if (!showAllVersions && versions.size() > 10) {
            ArrayList<Version> versionList = new ArrayList<Version>(versions);
            versions = versionList.subList(0, 10);
        }
        return versions;
    }

    private Collection<Long> getSelectedVersions(BrowseContext ctx, String uniqueKey) {
        String requestParameter;
        String key;
        Map<String, Object> session = this.getSession();
        HashSet<Long> versions = (HashSet<Long>)session.get(key = uniqueKey + "_selected_" + ctx.getContextKey());
        if (versions == null) {
            versions = new HashSet<Long>();
            session.put(key, versions);
        }
        if (!StringUtils.isEmpty((String)(requestParameter = this.getPassedParameter(EXPAND_VERSION)))) {
            versions.add(Long.valueOf(requestParameter));
        }
        if (!StringUtils.isEmpty((String)(requestParameter = this.getPassedParameter(COLLAPSE_VERSION)))) {
            versions.remove(Long.valueOf(requestParameter));
        }
        return versions;
    }

    private String getPassedParameter(String parameterName) {
        VelocityRequestContext context = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        return context.getRequestParameter(parameterName);
    }

    private Map<String, Object> getSession() {
        return ActionContext.getSession();
    }

    private Boolean showAllVersions(BrowseContext ctx, String uniqueKey) {
        String key = uniqueKey + "_allVersions_" + ctx.getContextKey();
        String requestParameter = this.getPassedParameter(ALL_VERSIONS);
        if (!StringUtils.isEmpty((String)requestParameter)) {
            Boolean showAllVersions = Boolean.valueOf(requestParameter);
            this.getSession().put(key, showAllVersions);
            return showAllVersions;
        }
        Boolean showAllVersions = (Boolean)this.getSession().get(key);
        return showAllVersions != null && showAllVersions != false;
    }

    private static JqlClauseBuilder addFixForClause(JqlClauseBuilder builder, Version version) {
        return builder.fixVersion().eq(version.getId());
    }

    public static class RoadMapGraphingBean {
        private final BrowseContext ctx;
        private final SearchProvider searchProvider;
        private final ConstantsManager constantsManager;
        private final SearchService searchService;
        private final StatisticAccessorBean statsBean;

        public RoadMapGraphingBean(BrowseContext ctx, SearchProvider searchProvider, ConstantsManager constantsManager, SearchService searchService) {
            this.ctx = ctx;
            this.searchProvider = searchProvider;
            this.constantsManager = constantsManager;
            this.searchService = searchService;
            this.statsBean = this.createStatsBean();
        }

        private StatisticAccessorBean createStatsBean() {
            JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
            if (this.ctx instanceof BrowseComponentContext) {
                builder.component(new Long[]{((BrowseComponentContext)this.ctx).getComponent().getId()});
            }
            return new StatisticAccessorBean(this.ctx.getUser(), this.ctx.getProject().getId(), builder.buildClause(), true);
        }

        public int getIssueCountByFixForVersion(Version version) throws SearchException {
            Query initialQuery = this.ctx.createQuery();
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder((Query)initialQuery).defaultAnd();
            VersionDrillDownRendererImpl.addFixForClause(builder, version);
            return (int)this.searchProvider.searchCount(builder.buildQuery(), this.ctx.getUser());
        }

        public int getIssueCountOpenByFixForVersion(Version version) throws Exception {
            return (int)this.statsBean.getOpenByFixFor(version);
        }

        public PercentageGraphModel getIssueSummaryByFixForVersion(Version version, ProjectComponent component, int openCount, int allCount) {
            if (allCount == 0) {
                return new PercentageGraphModel();
            }
            I18nBean i18nBean = new I18nBean(this.ctx.getUser());
            PercentageGraphModel model = new PercentageGraphModel();
            model.addRow("#009900", (long)(allCount - openCount), i18nBean.getText("common.concepts.resolved.issues"), this.getNavigatorUrl(this.ctx.getProject(), version, component, false));
            model.addRow("#cc0000", (long)openCount, i18nBean.getText("common.concepts.unresolved.issues"), this.getNavigatorUrl(this.ctx.getProject(), version, component, true));
            return model;
        }

        public String getNavigatorUrl(Project project, Version version, ProjectComponent component, boolean unresolved) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().defaultAnd();
            if (project != null) {
                builder.project(new String[]{project.getKey()});
            }
            if (version != null) {
                builder.fixVersion(version.getName());
            }
            if (component != null) {
                builder.component(new String[]{component.getName()});
            }
            if (!unresolved) {
                Collection resolutionObjects = this.constantsManager.getResolutionObjects();
                ArrayList resolutions = Lists.newArrayListWithCapacity((int)resolutionObjects.size());
                for (Resolution resolution : resolutionObjects) {
                    resolutions.add(resolution.getName());
                }
                if (!resolutions.isEmpty()) {
                    builder.resolution().in(resolutions.toArray(new String[resolutions.size()])).buildClause();
                }
            } else {
                builder.unresolved();
            }
            return this.searchService.getQueryString(this.ctx.getUser(), builder.buildQuery());
        }

        public String getResolvedQueryString() {
            Collection resolutionObjects = this.constantsManager.getResolutionObjects();
            ArrayList resolutions = Lists.newArrayListWithCapacity((int)resolutionObjects.size());
            for (Resolution resolution : resolutionObjects) {
                resolutions.add(new Long(resolution.getId()));
            }
            if (!resolutions.isEmpty()) {
                Clause resolutionClause = JqlQueryBuilder.newClauseBuilder().resolution().inNumbers((Collection)resolutions).buildClause();
                return this.getQuerySnipper(resolutionClause);
            }
            return "";
        }

        public String getUnresolvedQueryString() {
            Clause resolutionClause = JqlQueryBuilder.newClauseBuilder().unresolved().buildClause();
            return this.getQuerySnipper(resolutionClause);
        }

        private String getQuerySnipper(Clause clause) {
            QueryImpl query = new QueryImpl(clause);
            return this.searchService.getQueryString(this.ctx.getUser(), (Query)query);
        }
    }

    public static class VersionHelperBean {
        private final BrowseContext ctx;
        private final SearchProvider searchProvider;

        public VersionHelperBean(BrowseContext ctx, SearchProvider searchProvider) {
            this.ctx = ctx;
            this.searchProvider = searchProvider;
        }

        public SearchResults getSearchResultByFixForVersion(Version version) throws SearchException {
            Query initialQuery = this.ctx.createQuery();
            JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)initialQuery);
            JqlClauseBuilder whereBuilder = queryBuilder.where().defaultAnd();
            VersionDrillDownRendererImpl.addFixForClause(whereBuilder, version);
            queryBuilder.orderBy().clear().priority(SortOrder.DESC).status(SortOrder.ASC).resolution(SortOrder.ASC).summary(SortOrder.ASC);
            return this.searchProvider.search(queryBuilder.buildQuery(), this.ctx.getUser(), TabPanelUtil.PAGER_FILTER);
        }

        public Collection<Issue> getIssuesFromSearchResult(SearchResults searchResults) {
            List issues = searchResults.getIssues();
            Collections.sort(issues, new NullResolutionComparator());
            return issues;
        }
    }
}

