/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding;

import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.onboarding.FirstUseFlow;
import com.atlassian.jira.onboarding.FirstUseFlowModuleDescriptor;
import com.atlassian.jira.onboarding.OnboardingService;
import com.atlassian.jira.onboarding.OnboardingStore;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OnboardingServiceImpl
implements OnboardingService {
    private final OnboardingStore store;
    private final PluginAccessor pluginAccessor;
    private final GlobalPermissionManager permissionManager;
    private final FeatureManager featureManager;
    private final LoginService loginService;

    public OnboardingServiceImpl(PluginAccessor pluginAccessor, OnboardingStore store, GlobalPermissionManager permissionManager, FeatureManager featureManager, LoginService loginService) {
        this.pluginAccessor = pluginAccessor;
        this.store = store;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
        this.loginService = loginService;
    }

    @Override
    public boolean hasCompletedFirstUseFlow(@Nonnull ApplicationUser user) {
        return this.store.getBoolean(user, "jira.onboarding.first.use.flow.completed");
    }

    @Override
    public void completeFirstUseFlow(@Nonnull ApplicationUser user) {
        this.store.setBoolean(user, "jira.onboarding.first.use.flow.completed", true);
    }

    @Override
    public void setCurrentFirstUseFlowSequence(@Nonnull ApplicationUser user, @Nonnull String sequenceKey) {
        this.store.setString(user, "jira.onboarding.first.use.flow.current.sequence", sequenceKey);
    }

    @Override
    @Nullable
    public String getCurrentFirstUseFlowSequence(@Nonnull ApplicationUser user) {
        return this.store.getString(user, "jira.onboarding.first.use.flow.current.sequence");
    }

    @Override
    @Nullable
    public FirstUseFlow getFirstUseFlow(@Nullable ApplicationUser user) {
        if (this.featureManager.isEnabled("jira.onboarding.feature.disabled")) {
            return null;
        }
        if (user == null || this.hasResolvedFirstUseFlow(user)) {
            return null;
        }
        FirstUseFlow firstUseFlow = this.evaluateFirstUseFlowChoice(user);
        if (firstUseFlow == null) {
            this.resolveFirstUseFlow(user);
        }
        return firstUseFlow;
    }

    @Nullable
    private FirstUseFlow evaluateFirstUseFlowChoice(@Nonnull ApplicationUser user) {
        if (this.isOnDemandSysAdmin(user) || this.hasCompletedFirstUseFlow(user)) {
            return null;
        }
        if (this.hasStartedFirstUseFlow(user)) {
            String startedFlowKey = this.getStartedFirstUseFlowKey(user);
            if (startedFlowKey == null) {
                return null;
            }
            FirstUseFlowModuleDescriptor chosenFlowDescriptor = this.getFirstUseFlowModuleDescriptorByKey(startedFlowKey);
            if (chosenFlowDescriptor == null) {
                return null;
            }
            return (FirstUseFlow)chosenFlowDescriptor.getModule();
        }
        if (this.firstTimeLoggingIn(user)) {
            return this.startHighestWeightFlow(user);
        }
        return null;
    }

    @Nullable
    private FirstUseFlow startHighestWeightFlow(@Nonnull ApplicationUser user) {
        List<FirstUseFlowModuleDescriptor> flows = this.getOrderedFirstUseFlowDescriptors();
        for (FirstUseFlowModuleDescriptor flow : flows) {
            if (!((FirstUseFlow)flow.getModule()).isApplicable(user)) continue;
            this.markFirstUseFlowStarted(user, flow);
            return (FirstUseFlow)flow.getModule();
        }
        return null;
    }

    private void markFirstUseFlowStarted(@Nonnull ApplicationUser user, @Nonnull FirstUseFlowModuleDescriptor firstUseFlowModuleDescriptor) {
        this.store.setString(user, "jira.onboarding.first.use.flow.started", firstUseFlowModuleDescriptor.getKey());
    }

    private boolean hasStartedFirstUseFlow(@Nonnull ApplicationUser user) {
        return this.store.isSet(user, "jira.onboarding.first.use.flow.started");
    }

    private boolean hasResolvedFirstUseFlow(@Nonnull ApplicationUser user) {
        return this.store.getBoolean(user, "jira.onboarding.first.use.flow.resolved");
    }

    @Override
    @Nullable
    public String getStartedFirstUseFlowKey(@Nonnull ApplicationUser user) {
        return this.store.getString(user, "jira.onboarding.first.use.flow.started");
    }

    private boolean isOnDemandSysAdmin(@Nonnull ApplicationUser user) {
        return this.featureManager.isOnDemand() && this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    private boolean firstTimeLoggingIn(@Nonnull ApplicationUser user) {
        Long loginCount = this.loginService.getLoginInfo(user.getUsername()).getLoginCount();
        return loginCount != null && loginCount == 1L;
    }

    private void resolveFirstUseFlow(@Nonnull ApplicationUser user) {
        this.store.setBoolean(user, "jira.onboarding.first.use.flow.resolved", true);
    }

    @Nullable
    private FirstUseFlowModuleDescriptor getFirstUseFlowModuleDescriptorByKey(final @Nonnull String key) {
        List unfilteredDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(FirstUseFlowModuleDescriptor.class);
        FirstUseFlowModuleDescriptor matchingDescriptor = null;
        Iterable filteredDescriptors = Iterables.filter((Iterable)unfilteredDescriptors, (Predicate)new Predicate<FirstUseFlowModuleDescriptor>(){

            public boolean apply(@Nullable FirstUseFlowModuleDescriptor input) {
                return null != input && key.equals(input.getKey());
            }
        });
        Iterator iterator = filteredDescriptors.iterator();
        if (iterator.hasNext()) {
            matchingDescriptor = (FirstUseFlowModuleDescriptor)iterator.next();
        }
        return matchingDescriptor;
    }

    @Nonnull
    private List<FirstUseFlowModuleDescriptor> getOrderedFirstUseFlowDescriptors() {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(FirstUseFlowModuleDescriptor.class);
        ArrayList x = Lists.newArrayList((Iterable)descriptors);
        Collections.sort(x);
        return x;
    }
}

