/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding;

import com.atlassian.jira.onboarding.FirstUseFlow;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.dom4j.Element;

public class FirstUseFlowModuleDescriptor
extends AbstractJiraModuleDescriptor<FirstUseFlow>
implements Comparable<FirstUseFlowModuleDescriptor> {
    @VisibleForTesting
    static final int UNWEIGHTED = -1;
    private int weight;

    public FirstUseFlowModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        String weightValue = element.attributeValue("weight");
        try {
            this.weight = Integer.parseInt(weightValue);
        }
        catch (NumberFormatException e) {
            this.weight = -1;
        }
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(@Nullable FirstUseFlowModuleDescriptor o) {
        if (o == null) {
            return -1;
        }
        return Integer.valueOf(o.getWeight()).compareTo(this.getWeight());
    }
}

