/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.threading;

import com.atlassian.jira.issue.Issue;
import com.google.common.base.Preconditions;

public class EmailHeaderBuilders {
    private static String getCreatedDateInMillis(Issue issue, boolean dropMillis) {
        if (issue.getCreated() == null) {
            return "null";
        }
        long issueCreated = issue.getCreated().getTime();
        if (dropMillis) {
            issueCreated -= issueCreated % 1000L;
        }
        return Long.toString(issueCreated);
    }

    public static class InReplyToHeaderBuilder {
        private Issue issue;
        private String hostName;
        private boolean dropMillis = true;

        public InReplyToHeaderBuilder(Issue issue) {
            this.issue = issue;
        }

        public InReplyToHeaderBuilder setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public InReplyToHeaderBuilder setDropMillis(boolean dropMillis) {
            this.dropMillis = dropMillis;
            return this;
        }

        public String build() {
            Preconditions.checkNotNull((Object)this.hostName);
            return "<JIRA." + this.issue.getId() + "." + EmailHeaderBuilders.getCreatedDateInMillis(this.issue, this.dropMillis) + "@" + this.hostName + ">";
        }
    }

    public static class MessageIdBuilder {
        private Issue issue;
        private int sequence;
        private String hostName;
        private boolean hasSequence;
        private boolean dropMillis = true;

        public MessageIdBuilder(Issue issue) {
            this.issue = issue;
        }

        public MessageIdBuilder setSequence(int sequence) {
            this.sequence = sequence;
            this.hasSequence = true;
            return this;
        }

        public MessageIdBuilder setHostName(String hostName) {
            Preconditions.checkNotNull((Object)hostName);
            this.hostName = hostName;
            return this;
        }

        public MessageIdBuilder setDropMillis(boolean dropMillis) {
            this.dropMillis = dropMillis;
            return this;
        }

        public String build() {
            Preconditions.checkState((boolean)this.hasSequence);
            Preconditions.checkNotNull((Object)this.hostName);
            return "JIRA." + this.issue.getId() + '.' + EmailHeaderBuilders.getCreatedDateInMillis(this.issue, this.dropMillis) + '.' + this.sequence + '.' + System.currentTimeMillis() + "@" + this.hostName;
        }
    }
}

