/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.user.ApplicationUser;
import org.apache.commons.lang.StringUtils;

public class TemplateUser {
    private final ApplicationUser user;

    public static TemplateUser getUser(ApplicationUser user) {
        return new TemplateUser(user);
    }

    public String getEmailAddress() {
        String email;
        try {
            email = this.user.getEmailAddress();
            if (email == null) {
                email = "";
            }
        }
        catch (Exception exception) {
            email = "";
        }
        return email;
    }

    public String getEmail() {
        return this.getEmailAddress();
    }

    public String getDisplayName() {
        String fullName;
        try {
            if (this.user == null) {
                fullName = this.getName();
            } else {
                fullName = this.user.getDisplayName();
                if (StringUtils.isBlank((String)fullName)) {
                    fullName = this.getName();
                }
            }
        }
        catch (Exception exception) {
            fullName = this.getName();
        }
        return fullName;
    }

    public String getFullName() {
        return this.getDisplayName();
    }

    public String getName() {
        String name;
        try {
            name = this.user != null ? this.user.getName() : "Anonymous";
        }
        catch (Exception exception) {
            name = "";
        }
        return name;
    }

    public int hashCode() {
        return this.user.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        return this.user.equals(o);
    }

    private TemplateUser(ApplicationUser user) {
        this.user = user;
    }
}

