/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.license.MultiLicenseStore;
import com.atlassian.jira.license.ProductLicense;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@EventComponent
public class MultiLicenseStoreImpl
implements MultiLicenseStore {
    private static final String ID_COLUMN = "id";
    private final EntityEngine entityEngine;
    private final ApplicationProperties applicationProperties;
    private final CachedReference<ImmutableList<String>> cachedLicenses;

    public MultiLicenseStoreImpl(EntityEngine entityEngine, ApplicationProperties applicationProperties, CacheManager cacheManager) {
        this.entityEngine = entityEngine;
        this.applicationProperties = applicationProperties;
        this.cachedLicenses = cacheManager.getCachedReference("MultiLicenseStoreImpl.cachedLicenses", (Supplier)new LicenseSupplier(entityEngine));
    }

    @Override
    @Nonnull
    public Iterable<String> retrieve() {
        List multiStoredStrings = (List)this.cachedLicenses.get();
        if (!multiStoredStrings.isEmpty()) {
            return multiStoredStrings;
        }
        String fallback = this.retrieveOldLicense();
        if (fallback != null) {
            return ImmutableList.of((Object)fallback);
        }
        return ImmutableList.of();
    }

    private String retrieveOldLicense() {
        return this.applicationProperties.getText("License20");
    }

    @Override
    public void store(@Nonnull Iterable<String> newLicenseKeys) {
        Preconditions.checkNotNull(newLicenseKeys, (Object)"newLicenseKeys");
        if (Iterables.isEmpty(newLicenseKeys)) {
            throw new IllegalArgumentException("You must store at least one license.");
        }
        if (Iterables.any(newLicenseKeys, (Predicate)Predicates.isNull())) {
            throw new IllegalArgumentException("You cannot store null licenses - no changes have been made to licenses.");
        }
        this.clear();
        for (String licenseKey : newLicenseKeys) {
            this.entityEngine.createValue(Entity.PRODUCT_LICENSE, new ProductLicense(licenseKey));
        }
    }

    private void clearMultiLicenses() {
        this.entityEngine.delete(Delete.from(Entity.PRODUCT_LICENSE).all());
    }

    private void clearOldLicense() {
        this.applicationProperties.setText("License20", null);
    }

    @Override
    public void resetOldBuildConfirmation() {
        this.applicationProperties.setOption("jira.install.oldlicense.confirmed", false);
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.timestamp", "");
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.user", "");
    }

    @Override
    public void confirmProceedUnderEvaluationTerms(String userName) {
        this.applicationProperties.setOption("jira.install.oldlicense.confirmed", true);
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.user", userName);
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.timestamp", String.valueOf(System.currentTimeMillis()));
    }

    @Override
    public void clear() {
        try {
            this.clearOldLicense();
            this.clearMultiLicenses();
        }
        finally {
            this.clearCache();
        }
    }

    @EventListener
    public void onClearCacheEvent(ClearCacheEvent c) {
        this.clearCache();
    }

    @Override
    public void clearCache() {
        this.cachedLicenses.reset();
    }

    @Override
    public String retrieveServerId() {
        return this.applicationProperties.getString("jira.sid.key");
    }

    @Override
    public void storeServerId(String serverId) {
        this.applicationProperties.setString("jira.sid.key", serverId);
    }

    static class LicenseSupplier
    implements Supplier<ImmutableList<String>> {
        private final EntityEngine entityEngine;

        LicenseSupplier(EntityEngine entityEngine) {
            this.entityEngine = entityEngine;
        }

        public ImmutableList<String> get() {
            List<ProductLicense> list = this.entityEngine.selectFrom(Entity.PRODUCT_LICENSE).findAll().orderBy(MultiLicenseStoreImpl.ID_COLUMN);
            return ImmutableList.copyOf(this.extractStrings(list));
        }

        private List<String> extractStrings(List<ProductLicense> productLicenses) {
            ArrayList<String> result = new ArrayList<String>(productLicenses.size());
            for (ProductLicense productLicense : productLicenses) {
                if (productLicense == null) continue;
                result.add(productLicense.getLicenseKey());
            }
            return result;
        }
    }
}

