/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.cache.Supplier;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseDetailsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jira6xServiceDeskPluginLicenseSupplier
implements Supplier<Option<LicenseDetails>> {
    private static final Logger LOG = LoggerFactory.getLogger(Jira6xServiceDeskPluginLicenseSupplier.class);
    private final Jira6xServiceDeskPluginEncodedLicenseSupplier encodedLicenseSupplier;
    private final LicenseDetailsFactory licenseDetailsFactory;

    public Jira6xServiceDeskPluginLicenseSupplier(ApplicationProperties applicationProperties, LicenseDetailsFactory licenseDetailsFactory) {
        this.encodedLicenseSupplier = new Jira6xServiceDeskPluginEncodedLicenseSupplier(applicationProperties);
        this.licenseDetailsFactory = licenseDetailsFactory;
    }

    public Option<LicenseDetails> get() {
        try {
            return this.encodedLicenseSupplier.get().map(this.licenseDetailsFactory::getLicense).filter(this::isServiceDeskLicense);
        }
        catch (LicenseException invalidLicense) {
            LOG.debug("Invalid Service Desk plugin license", (Throwable)invalidLicense);
            return Option.none();
        }
    }

    private boolean isServiceDeskLicense(LicenseDetails licenseDetails) {
        if (!licenseDetails.getLicensedApplications().getKeys().contains(ApplicationKeys.SERVICE_DESK)) {
            LOG.debug("Invalid Service Desk plugin license");
            return false;
        }
        return true;
    }
}

